/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAttributePredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SimpleAttributePredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nonnull
    @NonnullElements
    private ListMultimap<String, String> attributeValueMap = ArrayListMultimap.create();

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setAttributeValueMap(@Nonnull @NonnullElements Map<String, Collection<String>> map) {
        Constraint.isNotNull(map, (String)"Attribute/value map cannot be null");
        this.attributeValueMap.clear();
        for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
            String attributeId = StringSupport.trimOrNull((String)entry.getKey());
            this.attributeValueMap.putAll((Object)attributeId, (Iterable)StringSupport.normalizeStringCollection(entry.getValue()));
        }
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        AttributeContext attributeCtx = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)input);
        if (attributeCtx == null) {
            this.log.warn("No AttributeContext located for evaluation");
            return this.attributeValueMap.isEmpty();
        }
        for (String id : this.attributeValueMap.keySet()) {
            this.log.debug("Checking for attribute: {}", (Object)id);
            IdPAttribute attribute = (IdPAttribute)attributeCtx.getIdPAttributes().get(id);
            if (attribute == null) {
                this.log.info("Attribute {} not found in context", (Object)id);
                return false;
            }
            boolean matched = false;
            for (String value : this.attributeValueMap.get((Object)id)) {
                if (!this.findMatch(value, attribute)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            this.log.info("Attribute {} values not matched", (Object)id);
            return false;
        }
        this.log.debug("Context satisfied requirements");
        return true;
    }

    private boolean findMatch(@Nonnull @NotEmpty String toMatch, @Nonnull IdPAttribute attribute) {
        if ("*".equals(toMatch)) {
            this.log.debug("Wildcard (*) value rule for attribute {}", (Object)attribute.getId());
            return true;
        }
        for (IdPAttributeValue value : attribute.getValues()) {
            if (!(value instanceof StringAttributeValue) || !toMatch.equals(value.getValue())) continue;
            this.log.debug("Found matching value ({}) in attribute {}", (Object)toMatch, (Object)attribute.getId());
            return true;
        }
        return false;
    }
}

