/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile;

import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionTestingSupport;
import net.shibboleth.idp.profile.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.PreviousEventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractProfileActionTest {
    @Test
    public void testActionExecution() throws Exception {
        RequestContext springRequestContext = new RequestContextBuilder().buildRequestContext();
        MockProfileAction action = new MockProfileAction();
        action.initialize();
        Event result = action.execute(springRequestContext);
        Assert.assertTrue((boolean)action.isExecuted());
        ActionTestingSupport.assertProceedEvent(result);
        action = new MockProfileAction(new RuntimeException());
        action.initialize();
        try {
            action.execute(springRequestContext);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        action = new MockProfileAction(new RuntimeException());
        try {
            action.execute(springRequestContext);
            Assert.fail();
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
    }

    @Test
    public void testActionEvent() throws Exception {
        RequestContext springRequestContext = new RequestContextBuilder().buildRequestContext();
        MockProfileAction action = new MockProfileAction("Event1", "Event2");
        action.initialize();
        Event result = action.execute(springRequestContext);
        ActionTestingSupport.assertEvent(result, "InvalidPreviousEvent");
        action = new MockProfileAction("Event1", "InvalidPreviousEvent");
        action.initialize();
        result = action.execute(springRequestContext);
        ActionTestingSupport.assertEvent(result, "Event1");
        action = new MockProfileAction("Event2", "Event1");
        action.initialize();
        result = action.execute(springRequestContext);
        ActionTestingSupport.assertEvent(result, "Event2");
        action = new MockProfileAction("Event3", "Event1");
        action.initialize();
        result = action.execute(springRequestContext);
        ActionTestingSupport.assertEvent(result, "InvalidPreviousEvent");
    }

    private class MockProfileAction
    extends AbstractProfileAction {
        private final String newEvent;
        private final String prevEvent;
        private final RuntimeException thrownException;
        private boolean executed;

        public MockProfileAction() {
            this.thrownException = null;
            this.newEvent = null;
            this.prevEvent = null;
        }

        public MockProfileAction(RuntimeException exception) {
            this.thrownException = exception;
            this.newEvent = null;
            this.prevEvent = null;
        }

        public MockProfileAction(String newEvent, String prevEvent) {
            this.newEvent = newEvent;
            this.prevEvent = prevEvent;
            this.thrownException = null;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        protected void doExecute(ProfileRequestContext profileRequestContext) {
            this.executed = true;
            PreviousEventContext prevCtx = (PreviousEventContext)profileRequestContext.getSubcontext(PreviousEventContext.class, false);
            if (this.prevEvent != null) {
                if (prevCtx == null || !prevCtx.getEvent().equals(this.prevEvent)) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidPreviousEvent");
                    return;
                }
            } else if (prevCtx != null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidPreviousEvent");
                return;
            }
            if (this.thrownException != null) {
                throw this.thrownException;
            }
            if (this.newEvent != null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.newEvent);
            }
        }
    }
}

