/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty;

import java.util.ArrayList;
import net.shibboleth.idp.relyingparty.MockProfileConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RelyingPartyConfigurationTest {
    @Test
    public void testConstruction() {
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setDetailedErrors(true);
        Assert.assertEquals((String)config.getId(), (String)"foo");
        Assert.assertEquals((String)config.getResponderId(), (String)"http://idp.example.org");
        Assert.assertTrue((boolean)config.isDetailedErrors());
        Assert.assertTrue((boolean)config.getProfileConfigurations().isEmpty());
        config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setDetailedErrors(false);
        Assert.assertEquals((String)config.getId(), (String)"foo");
        Assert.assertEquals((String)config.getResponderId(), (String)"http://idp.example.org");
        Assert.assertFalse((boolean)config.isDetailedErrors());
        Assert.assertTrue((boolean)config.getProfileConfigurations().isEmpty());
        ArrayList<MockProfileConfiguration> profileConfigs = new ArrayList<MockProfileConfiguration>();
        profileConfigs.add(new MockProfileConfiguration("foo"));
        profileConfigs.add(null);
        profileConfigs.add(new MockProfileConfiguration("bar"));
        config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setProfileConfigurations(profileConfigs);
        Assert.assertEquals((String)config.getId(), (String)"foo");
        Assert.assertEquals((String)config.getResponderId(), (String)"http://idp.example.org");
        Assert.assertEquals((int)config.getProfileConfigurations().size(), (int)2);
        try {
            config = new RelyingPartyConfiguration();
            config.setId(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            config = new RelyingPartyConfiguration();
            config.setId("");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            config = new RelyingPartyConfiguration();
            config.setResponderId(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testProfileConfiguration() {
        ArrayList<MockProfileConfiguration> profileConfigs = new ArrayList<MockProfileConfiguration>();
        profileConfigs.add(new MockProfileConfiguration("foo"));
        profileConfigs.add(new MockProfileConfiguration("bar"));
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setId("foo");
        config.setResponderId("http://idp.example.org");
        config.setProfileConfigurations(profileConfigs);
        Assert.assertNotNull((Object)config.getProfileConfiguration("foo"));
        Assert.assertNotNull((Object)config.getProfileConfiguration("bar"));
        Assert.assertNull((Object)config.getProfileConfiguration("baz"));
    }
}

