/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ScriptedAction
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_ENGINE = "JavaScript";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedAction.class);
    @Nonnull
    private final EvaluableScript script;
    @Nullable
    private final String logPrefix;
    @Nullable
    private Object customObject;

    public ScriptedAction(@Nonnull EvaluableScript theScript, @Nullable String extraInfo) {
        this.script = (EvaluableScript)Constraint.isNotNull((Object)theScript, (String)"Supplied script should not be null");
        this.logPrefix = "Scripted Action from " + extraInfo + " :";
    }

    public ScriptedAction(@Nonnull EvaluableScript theScript) {
        this.script = (EvaluableScript)Constraint.isNotNull((Object)theScript, (String)"Supplied script should not be null");
        this.logPrefix = "Anonymous Scripted Action :";
    }

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    @Nullable
    public void setCustomObject(Object object) {
        this.customObject = object;
    }

    public void doExecute(@Nullable ProfileRequestContext profileContext) {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute("profileContext", profileContext, 100);
        scriptContext.setAttribute("custom", this.getCustomObject(), 100);
        try {
            Object result = this.script.eval((ScriptContext)scriptContext);
            if (null == result) {
                ActionSupport.buildProceedEvent((ProfileRequestContext)profileContext);
                return;
            }
            if (result instanceof String) {
                this.log.debug("{} signaled Event: {}", (Object)this.logPrefix, result);
                ActionSupport.buildEvent((ProfileRequestContext)profileContext, (String)((String)result));
            } else {
                this.log.error("{} returned a {}, not a java.lang.String", (Object)this.logPrefix, (Object)result.getClass().toString());
                ActionSupport.buildEvent((ProfileRequestContext)profileContext, (String)"InvalidProfileContext");
            }
        }
        catch (ScriptException e) {
            this.log.error("{} Error while executing Action script", (Object)this.logPrefix, (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileContext, (String)"InvalidProfileContext");
        }
    }

    static ScriptedAction resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript(engineName, is);
            ScriptedAction scriptedAction = new ScriptedAction(script, resource.getDescription());
            return scriptedAction;
        }
    }

    static ScriptedAction resourceScript(@Nonnull Resource resource) throws ScriptException, IOException {
        return ScriptedAction.resourceScript(DEFAULT_ENGINE, resource);
    }

    static ScriptedAction inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedAction(script, "Inline");
    }

    static ScriptedAction inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(DEFAULT_ENGINE, scriptSource);
        return new ScriptedAction(script, "Inline");
    }
}

