/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.profile.logic.AbstractAttributePredicate;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexAttributePredicate
extends AbstractAttributePredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RegexAttributePredicate.class);
    @Nullable
    @NotEmpty
    private String attributeId;
    @Nullable
    private Pattern pattern;

    @Nullable
    @NotEmpty
    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(@Nonnull @NotEmpty String id) {
        this.attributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Attribute ID cannot be null or empty");
    }

    @Nullable
    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(@Nonnull Pattern p) {
        this.pattern = p;
    }

    public void setPattern(@Nonnull @NotEmpty String s) {
        this.pattern = Pattern.compile(s);
    }

    @Override
    protected boolean hasMatch(@Nonnull @NonnullElements Map<String, IdPAttribute> attributeMap) {
        if (this.attributeId == null || this.pattern == null) {
            this.log.warn("Attribute ID or regular expression were not set");
            return false;
        }
        IdPAttribute attribute = attributeMap.get(this.attributeId);
        if (attribute == null) {
            this.log.debug("Attribute '{}' not found in context", (Object)this.attributeId);
            return false;
        }
        for (IdPAttributeValue value : attribute.getValues()) {
            Matcher m;
            if (!(value instanceof StringAttributeValue) || !(m = this.pattern.matcher((String)value.getValue())).matches()) continue;
            this.log.debug("Found matching value '{}' in attribute '{}'", (Object)m.group(), (Object)this.attributeId);
            return true;
        }
        this.log.debug("Attribute '{}' values not matched", (Object)this.attributeId);
        return false;
    }
}

