/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpringExpressionPredicate
implements Predicate<ProfileRequestContext<?, ?>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionPredicate.class);
    @Nullable
    private String springExpression;
    @Nullable
    private Object customObject;
    private boolean hideExceptions;
    private boolean returnOnError;

    public SpringExpressionPredicate(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        this.springExpression = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)expression), (String)"Expression cannot be null or empty");
    }

    public void setCustomObject(@Nullable Object object) {
        this.customObject = object;
    }

    public void setHideExceptions(boolean flag) {
        this.hideExceptions = flag;
    }

    public void setReturnOnError(boolean flag) {
        this.returnOnError = flag;
    }

    public boolean apply(@Nullable ProfileRequestContext<?, ?> input) {
        try {
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("custom", this.customObject);
            context.setVariable("profileContext", input);
            return (Boolean)parser.parseExpression(this.springExpression).getValue((EvaluationContext)context, Boolean.class);
        }
        catch (EvaluationException | ParseException e) {
            this.log.error("Error evaluating Spring expression", e);
            if (this.hideExceptions) {
                return this.returnOnError;
            }
            throw e;
        }
    }
}

