/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.MockProfileConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

public class RequestContextBuilder {
    private final String NO_VAL = "novalue";
    private ServletContext servletContext;
    private HttpServletRequest httpRequest;
    private HttpServletResponse httpResponse;
    private String inboundMessageId = "novalue";
    private long inboundMessageIssueInstant;
    private String inboundMessageIssuer = "novalue";
    private Object inboundMessage;
    private String outboundMessageId = "novalue";
    private long outboundMessageIssueInstant;
    private String outboundMessageIssuer = "novalue";
    private Object outboundMessage;
    private Collection<ProfileConfiguration> relyingPartyProfileConfigurations;

    public RequestContextBuilder() {
    }

    public RequestContextBuilder(RequestContextBuilder prototype) {
        this.servletContext = prototype.servletContext;
        this.httpRequest = prototype.httpRequest;
        this.httpResponse = prototype.httpResponse;
        this.inboundMessageId = prototype.inboundMessageId;
        this.inboundMessageIssueInstant = prototype.inboundMessageIssueInstant;
        this.inboundMessageIssuer = prototype.inboundMessageIssuer;
        this.inboundMessage = prototype.inboundMessage;
        this.outboundMessageId = prototype.outboundMessageId;
        this.outboundMessageIssueInstant = prototype.outboundMessageIssueInstant;
        this.outboundMessageIssuer = prototype.outboundMessageIssuer;
        this.outboundMessage = prototype.outboundMessage;
        if (prototype.relyingPartyProfileConfigurations != null) {
            this.relyingPartyProfileConfigurations = new ArrayList<ProfileConfiguration>(prototype.relyingPartyProfileConfigurations);
        }
    }

    @Nonnull
    public RequestContextBuilder setServletContext(@Nullable ServletContext context) {
        this.servletContext = context;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setHttpRequest(@Nullable HttpServletRequest request) {
        this.httpRequest = request;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setHttpResponse(@Nullable HttpServletResponse response) {
        this.httpResponse = response;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessageId(@Nullable String id) {
        this.inboundMessageId = id;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessageIssueInstant(long instant) {
        this.inboundMessageIssueInstant = instant;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessageIssuer(@Nullable String issuer) {
        this.inboundMessageIssuer = issuer;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessage(@Nullable Object message) {
        this.inboundMessage = message;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setOutboundMessageId(@Nullable String id) {
        this.outboundMessageId = id;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setOutboundMessageIssueInstant(long instant) {
        this.outboundMessageIssueInstant = instant;
        return this;
    }

    public RequestContextBuilder setOutboundMessageIssuer(@Nullable String issuer) {
        this.outboundMessageIssuer = issuer;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setOutboundMessage(@Nullable Object message) {
        this.outboundMessage = message;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setRelyingPartyProfileConfigurations(@Nullable Collection<ProfileConfiguration> configs) {
        this.relyingPartyProfileConfigurations = configs;
        return this;
    }

    @Nonnull
    public RequestContext buildRequestContext() throws ComponentInitializationException {
        MockRequestContext context = new MockRequestContext();
        context.setExternalContext((ExternalContext)this.buildServletExternalContext());
        MutableAttributeMap scope = context.getConversationScope();
        scope.put("opensamlProfileRequestContext", (Object)this.buildProfileRequestContext());
        return context;
    }

    @Nonnull
    public ServletExternalContext buildServletExternalContext() {
        if (this.servletContext == null) {
            this.servletContext = new MockServletContext();
        }
        if (this.httpRequest == null) {
            this.httpRequest = new MockHttpServletRequest();
        }
        if (this.httpResponse == null) {
            this.httpResponse = new MockHttpServletResponse();
        }
        return new ServletExternalContext(this.servletContext, this.httpRequest, this.httpResponse);
    }

    @Nonnull
    public ProfileRequestContext buildProfileRequestContext() throws ComponentInitializationException {
        ProfileRequestContext profileContext = new ProfileRequestContext();
        profileContext.setInboundMessageContext(this.buildInboundMessageContext());
        profileContext.setOutboundMessageContext(this.buildOutboundMessageContext());
        this.buildRelyingPartyContext(profileContext);
        return profileContext;
    }

    @Nonnull
    protected MessageContext buildInboundMessageContext() {
        MessageContext context = new MessageContext();
        context.setMessage(this.inboundMessage);
        return context;
    }

    @Nonnull
    protected MessageContext buildOutboundMessageContext() {
        MessageContext context = new MessageContext();
        context.setMessage(this.outboundMessage);
        return context;
    }

    @Nonnull
    protected RelyingPartyContext buildRelyingPartyContext(@Nonnull ProfileRequestContext profileRequestContext) throws ComponentInitializationException {
        RelyingPartyContext rpCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class, true);
        if (Objects.equals("novalue", this.inboundMessageIssuer) || this.inboundMessageIssuer == null) {
            rpCtx.setRelyingPartyId("http://sp.example.org");
        } else {
            rpCtx.setRelyingPartyId(this.inboundMessageIssuer);
        }
        RelyingPartyConfiguration rpConfig = this.buildRelyingPartyConfiguration();
        rpCtx.setConfiguration(rpConfig);
        rpCtx.setProfileConfig(this.selectProfileConfiguration(rpConfig.getProfileConfigurations()));
        return rpCtx;
    }

    @Nonnull
    protected RelyingPartyConfiguration buildRelyingPartyConfiguration() throws ComponentInitializationException {
        ArrayList<MockProfileConfiguration> profileConfigs;
        String responderId = Objects.equals("novalue", this.outboundMessageIssuer) || this.outboundMessageIssuer == null ? "http://idp.example.org" : this.outboundMessageIssuer;
        if (this.relyingPartyProfileConfigurations == null) {
            this.relyingPartyProfileConfigurations = new ArrayList<ProfileConfiguration>();
        }
        if ((profileConfigs = new ArrayList<MockProfileConfiguration>(Collections2.filter(this.relyingPartyProfileConfigurations, (Predicate)Predicates.notNull()))).isEmpty()) {
            profileConfigs.add(new MockProfileConfiguration("mock"));
        }
        RelyingPartyConfiguration rp = new RelyingPartyConfiguration();
        rp.setId("mock");
        rp.setResponderId(responderId);
        rp.setDetailedErrors(true);
        rp.setProfileConfigurations(profileConfigs);
        rp.initialize();
        return rp;
    }

    @Nullable
    protected ProfileConfiguration selectProfileConfiguration(@Nonnull Map<String, ProfileConfiguration> rpProfileConfigs) {
        return rpProfileConfigs.values().iterator().next();
    }
}

