/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.relyingparty.MockProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractProfileConfigurationTest {
    @Test
    public void testProfileId() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        Assert.assertEquals((String)config.getId(), (String)"mock");
        try {
            config = new MockProfileConfiguration(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            config = new MockProfileConfiguration("");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testSecurityConfiguration() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        Assert.assertNotNull((Object)config.getSecurityConfiguration());
        SecurityConfiguration securityConfig = new SecurityConfiguration();
        config.setSecurityConfiguration(securityConfig);
        Assert.assertSame((Object)config.getSecurityConfiguration(), (Object)securityConfig);
    }

    @Test
    public void testIndirectSecurityConfiguration() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        config.setSecurityConfiguration(null);
        SecurityConfiguration securityConfig = new SecurityConfiguration();
        config.setSecurityConfigurationLookupStrategy(FunctionSupport.constant((Object)securityConfig));
        Assert.assertSame((Object)config.getSecurityConfiguration(), (Object)securityConfig);
    }

    @Test
    public void testInboundFlows() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        List<String> flows = Arrays.asList("foo", "bar");
        config.setInboundInterceptorFlows(flows);
        Assert.assertEquals((Collection)config.getInboundInterceptorFlows(), flows);
    }

    @Test
    public void testIndirectInboundFlows() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        List<String> flows = Arrays.asList("foo", "bar");
        config.setInboundFlowsLookupStrategy(FunctionSupport.constant(flows));
        Assert.assertEquals((Collection)config.getInboundInterceptorFlows(), flows);
    }

    @Test
    public void testOutboundFlows() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        List<String> flows = Arrays.asList("foo", "bar");
        config.setOutboundInterceptorFlows(flows);
        Assert.assertEquals((Collection)config.getOutboundInterceptorFlows(), flows);
    }

    @Test
    public void testIndirectOutboundFlows() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        List<String> flows = Arrays.asList("foo", "bar");
        config.setOutboundFlowsLookupStrategy(FunctionSupport.constant(flows));
        Assert.assertEquals((Collection)config.getOutboundInterceptorFlows(), flows);
    }

    @Test
    public void testDisallowedFeatures() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        Assert.assertEquals((int)config.getDisallowedFeatures(), (int)0);
        config.setDisallowedFeatures(5);
        Assert.assertTrue((boolean)config.isFeatureDisallowed(1));
        Assert.assertFalse((boolean)config.isFeatureDisallowed(2));
        Assert.assertTrue((boolean)config.isFeatureDisallowed(4));
    }

    @Test
    public void testIndirectDisallowedFeatures() {
        MockProfileConfiguration config = new MockProfileConfiguration("mock");
        Assert.assertEquals((int)config.getDisallowedFeatures(), (int)0);
        config.setDisallowedFeaturesLookupStrategy(FunctionSupport.constant((Object)5));
        Assert.assertTrue((boolean)config.isFeatureDisallowed(1));
        Assert.assertFalse((boolean)config.isFeatureDisallowed(2));
        Assert.assertTrue((boolean)config.isFeatureDisallowed(4));
    }
}

