/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProfileConfiguration
implements ProfileConfiguration {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractProfileConfiguration.class);
    @Nullable
    private ServletRequest servletRequest;
    @Nonnull
    @NotEmpty
    private final String profileId;
    @Nullable
    private Function<ProfileRequestContext, List<String>> inboundFlowsLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<String> inboundFlows;
    @Nullable
    private Function<ProfileRequestContext, List<String>> outboundFlowsLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<String> outboundFlows;
    @Nullable
    private Function<ProfileRequestContext, SecurityConfiguration> securityConfigurationLookupStrategy;
    @Nullable
    private SecurityConfiguration securityConfiguration;
    @Nullable
    private Function<ProfileRequestContext, Integer> disallowedFeaturesLookupStrategy;
    private int disallowedFeatures;

    public AbstractProfileConfiguration(@Nonnull @ParameterName(name="id") @NotEmpty String id) {
        this.profileId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Profile identifier cannot be null or empty");
        this.inboundFlows = Collections.emptyList();
        this.outboundFlows = Collections.emptyList();
    }

    public void setServletRequest(@Nullable ServletRequest request) {
        this.servletRequest = request;
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.profileId;
    }

    @Override
    @Nullable
    public SecurityConfiguration getSecurityConfiguration() {
        return this.getIndirectProperty(this.securityConfigurationLookupStrategy, this.securityConfiguration);
    }

    public void setSecurityConfiguration(@Nullable SecurityConfiguration configuration) {
        this.securityConfiguration = configuration;
    }

    public void setSecurityConfigurationLookupStrategy(@Nullable Function<ProfileRequestContext, SecurityConfiguration> strategy) {
        this.securityConfigurationLookupStrategy = strategy;
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getInboundInterceptorFlows() {
        return ImmutableList.copyOf((Collection)this.getIndirectProperty(this.inboundFlowsLookupStrategy, this.inboundFlows));
    }

    public void setInboundInterceptorFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.inboundFlows = flows != null ? new ArrayList<String>(StringSupport.normalizeStringCollection(flows)) : Collections.emptyList();
    }

    public void setInboundFlowsLookupStrategy(@Nullable Function<ProfileRequestContext, List<String>> strategy) {
        this.inboundFlowsLookupStrategy = strategy;
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getOutboundInterceptorFlows() {
        return ImmutableList.copyOf((Collection)this.getIndirectProperty(this.outboundFlowsLookupStrategy, this.outboundFlows));
    }

    public void setOutboundInterceptorFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.outboundFlows = flows != null ? new ArrayList<String>(StringSupport.normalizeStringCollection(flows)) : Collections.emptyList();
    }

    public void setOutboundFlowsLookupStrategy(@Nullable Function<ProfileRequestContext, List<String>> strategy) {
        this.outboundFlowsLookupStrategy = strategy;
    }

    public boolean isFeatureDisallowed(int feature) {
        return (this.getDisallowedFeatures() & feature) == feature;
    }

    public int getDisallowedFeatures() {
        return this.getIndirectProperty(this.disallowedFeaturesLookupStrategy, this.disallowedFeatures);
    }

    public void setDisallowedFeatures(int mask) {
        this.disallowedFeatures = mask;
    }

    public void setDisallowedFeaturesLookupStrategy(@Nullable Function<ProfileRequestContext, Integer> strategy) {
        this.disallowedFeaturesLookupStrategy = strategy;
    }

    public int hashCode() {
        return this.profileId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractProfileConfiguration)) {
            return false;
        }
        AbstractProfileConfiguration other = (AbstractProfileConfiguration)obj;
        return Objects.equals(this.profileId, other.getId());
    }

    @Nullable
    protected ProfileRequestContext getProfileRequestContext() {
        if (this.servletRequest != null) {
            Object object = this.servletRequest.getAttribute("opensamlProfileRequestContext");
            if (object instanceof ProfileRequestContext) {
                return (ProfileRequestContext)object;
            }
            this.log.warn("ProfileConfiguration {}: No ProfileRequestContext in request", (Object)this.getId());
        } else {
            this.log.warn("ProfileConfiguration {}: ServletRequest was null", (Object)this.getId());
        }
        return null;
    }

    @Nullable
    protected <T> T getIndirectProperty(@Nullable Function<ProfileRequestContext, T> lookupStrategy, @Nullable T staticValue) {
        Object prop;
        if (lookupStrategy != null && (prop = lookupStrategy.apply((Object)this.getProfileRequestContext())) != null) {
            return (T)prop;
        }
        return staticValue;
    }
}

