/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate;

import java.util.Locale;
import net.shibboleth.idp.profile.RequestContextBuilder;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.idp.profile.context.navigate.SpringStatusMessageLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SpringStatusMessageLookupFunctionTest {
    private MockRequestContext springRequestContext;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.springRequestContext = (MockRequestContext)new RequestContextBuilder().buildRequestContext();
        this.prc = (ProfileRequestContext)this.springRequestContext.getConversationScope().get("opensamlProfileRequestContext");
        ((SpringRequestContext)this.prc.getSubcontext(SpringRequestContext.class, true)).setRequestContext((RequestContext)this.springRequestContext);
    }

    @Test
    public void testMappedMessage() {
        SpringStatusMessageLookupFunction fn = new SpringStatusMessageLookupFunction();
        fn.setMessageSource((MessageSource)new MockMessageSource());
        String message = fn.apply(this.prc);
        Assert.assertNull((Object)message);
        this.springRequestContext.setCurrentEvent(new Event((Object)this, "Mappable"));
        message = fn.apply(this.prc);
        Assert.assertEquals((String)message, (String)"Mapped");
    }

    private class MockMessageSource
    implements MessageSource {
        private MockMessageSource() {
        }

        public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
            if (code.equals("Mappable")) {
                return "Mapped";
            }
            return defaultMessage;
        }

        public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
            if (code.equals("Mappable")) {
                return "Mapped";
            }
            throw new NoSuchMessageException("No such message");
        }

        public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
            if (resolvable.getCodes()[0].equals("Mappable")) {
                return "Mapped";
            }
            throw new NoSuchMessageException("No such message");
        }
    }
}

