/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate;

import net.shibboleth.idp.profile.context.navigate.SpringExpressionContextLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SpringExpressionContextLookupFunctionTest {
    @Test
    public void simpleTest() {
        SpringExpressionContextLookupFunction func = new SpringExpressionContextLookupFunction(ProfileRequestContext.class, "99", Integer.class);
        Assert.assertEquals((Object)func.apply(null), (Object)99);
    }

    @Test
    public void customTest() {
        SpringExpressionContextLookupFunction func = new SpringExpressionContextLookupFunction(ProfileRequestContext.class, "#custom + 1", Integer.class);
        func.setCustomObject((Object)99);
        Assert.assertEquals((Object)func.apply(null), (Object)100);
    }

    @Test
    public void invalidOutputTest() {
        SpringExpressionContextLookupFunction func = new SpringExpressionContextLookupFunction(ProfileRequestContext.class, "'foo'", Integer.class);
        func.setReturnOnError((Object)-1);
        Assert.assertEquals((Object)func.apply(null), (Object)-1);
    }

    @Test
    public void exceptionTest() {
        SpringExpressionContextLookupFunction func = new SpringExpressionContextLookupFunction(ProfileRequestContext.class, "1/0", Integer.class);
        func.setReturnOnError((Object)-1);
        try {
            func.apply(null);
            Assert.fail((String)"Expression should have raised exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        func.setHideExceptions(true);
        Assert.assertEquals((Object)func.apply(null), (Object)-1);
    }
}

