/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ScriptedAction
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_ENGINE = "JavaScript";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedAction.class);
    @Nonnull
    private final ActionScriptEvaluator scriptEvaluator;

    @Deprecated
    public ScriptedAction(@Nonnull EvaluableScript theScript, @Nullable String extraInfo) {
        this.scriptEvaluator = new ActionScriptEvaluator(theScript);
    }

    public ScriptedAction(@Nonnull EvaluableScript theScript) {
        this.scriptEvaluator = new ActionScriptEvaluator(theScript);
    }

    @Nullable
    public Object getCustomObject() {
        return this.scriptEvaluator.getCustomObject();
    }

    @Nullable
    public void setCustomObject(@Nullable Object object) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.scriptEvaluator.setCustomObject(object);
    }

    public void setHideExceptions(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.scriptEvaluator.setHideExceptions(flag);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.scriptEvaluator.setLogPrefix(this.getLogPrefix());
    }

    public void doExecute(@Nullable ProfileRequestContext profileContext) {
        String result = this.scriptEvaluator.execute(profileContext);
        if (result == null) {
            this.log.debug("{} signaled proceed event", (Object)this.getLogPrefix());
            ActionSupport.buildProceedEvent((ProfileRequestContext)profileContext);
        } else {
            this.log.debug("{} signaled event: {}", (Object)this.getLogPrefix(), (Object)result);
            ActionSupport.buildEvent((ProfileRequestContext)profileContext, (String)result);
        }
    }

    static ScriptedAction resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initializeWithScriptException();
            ScriptedAction scriptedAction = new ScriptedAction(script);
            return scriptedAction;
        }
    }

    static ScriptedAction resourceScript(@Nonnull Resource resource) throws ScriptException, IOException {
        return ScriptedAction.resourceScript(DEFAULT_ENGINE, resource);
    }

    static ScriptedAction inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedAction(script);
    }

    static ScriptedAction inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        return ScriptedAction.inlineScript(DEFAULT_ENGINE, scriptSource);
    }

    private class ActionScriptEvaluator
    extends AbstractScriptEvaluator {
        public ActionScriptEvaluator(EvaluableScript theScript) {
            super(theScript);
            this.setOutputType(String.class);
            this.setReturnOnError("InvalidProfileContext");
        }

        @Nullable
        public Object getCustomObject() {
            return super.getCustomObject();
        }

        @Nullable
        public String execute(@Nullable ProfileRequestContext profileContext) {
            return (String)this.evaluate(new Object[]{profileContext});
        }

        protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
            scriptContext.setAttribute("profileContext", input[0], 100);
        }
    }
}

