/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config.navigate.messaging;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.messaging.AbstractRelyingPartyLookupFunction;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;

public class SignatureSigningConfigurationLookupFunction
extends AbstractRelyingPartyLookupFunction<List<SignatureSigningConfiguration>> {
    @Nullable
    private RelyingPartyConfigurationResolver rpResolver;

    public void setRelyingPartyConfigurationResolver(@Nullable RelyingPartyConfigurationResolver resolver) {
        this.rpResolver = resolver;
    }

    @Nullable
    public List<SignatureSigningConfiguration> apply(@Nullable MessageContext input) {
        ArrayList<SignatureSigningConfiguration> configs = new ArrayList<SignatureSigningConfiguration>();
        RelyingPartyContext rpc = this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            SecurityConfiguration defaultConfig;
            SecurityConfiguration sc;
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && (sc = pc.getSecurityConfiguration(this.getProfileRequestContextLookupStrategy().apply(input))) != null && sc.getSignatureSigningConfiguration() != null) {
                configs.add(sc.getSignatureSigningConfiguration());
            }
            if (pc != null && this.rpResolver != null && (defaultConfig = this.rpResolver.getDefaultSecurityConfiguration(pc.getId())) != null && defaultConfig.getSignatureSigningConfiguration() != null) {
                configs.add(defaultConfig.getSignatureSigningConfiguration());
            }
        }
        configs.add(SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration());
        return configs;
    }
}

