/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import java.time.Instant;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.profile.logic.AbstractAttributePredicate;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.joda.time.Duration;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateAttributePredicate
extends AbstractAttributePredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DateAttributePredicate.class);
    @Nonnull
    @NotEmpty
    private final String attributeName;
    @Nullable
    private java.time.format.DateTimeFormatter dateTimeFormatter;
    @Deprecated
    @Nullable
    private DateTimeFormatter legacyFormatter;
    @Nonnull
    private java.time.Duration systemTimeOffset;
    private boolean resultIfMissing;

    @Deprecated
    public DateAttributePredicate(@Nonnull @ParameterName(name="attribute") @NotEmpty String attribute) {
        this(attribute, ISODateTimeFormat.dateOptionalTimeParser());
    }

    @Deprecated
    public DateAttributePredicate(@Nonnull @ParameterName(name="attribute") @NotEmpty String attribute, @Nonnull @ParameterName(name="formatter") DateTimeFormatter formatter) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"Joda-Time-based constructor", (String)DateAttributePredicate.class.getName(), (String)"(see Javadoc)");
        this.attributeName = (String)Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        this.legacyFormatter = (DateTimeFormatter)Constraint.isNotNull((Object)formatter, (String)"Formatter cannot be null");
        this.systemTimeOffset = java.time.Duration.ZERO;
    }

    public DateAttributePredicate(@Nonnull @ParameterName(name="attribute") @NotEmpty String attribute, @Nonnull @ParameterName(name="formatter") java.time.format.DateTimeFormatter formatter) {
        this.attributeName = (String)Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        this.dateTimeFormatter = (java.time.format.DateTimeFormatter)Constraint.isNotNull((Object)formatter, (String)"Formatter cannot be null");
        this.systemTimeOffset = java.time.Duration.ZERO;
    }

    public DateAttributePredicate(@Nonnull @ParameterName(name="attribute") @NotEmpty String attribute, @Nonnull @ParameterName(name="formatString") @NotEmpty String formatString) {
        this.attributeName = (String)Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        this.dateTimeFormatter = java.time.format.DateTimeFormatter.ofPattern((String)Constraint.isNotNull((Object)formatString, (String)"Format string cannot be null"));
        this.systemTimeOffset = java.time.Duration.ZERO;
    }

    @Deprecated
    public void setSystemTimeOffset(@Nonnull Duration offset) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"Joda-Time-based setSystemTimeOffset", (String)DateAttributePredicate.class.getName(), (String)"setOffset");
        this.systemTimeOffset = java.time.Duration.ofMillis(((Duration)Constraint.isNotNull((Object)offset, (String)"Offset cannot be null")).getMillis());
    }

    public void setOffset(@Nonnull java.time.Duration offset) {
        this.systemTimeOffset = (java.time.Duration)Constraint.isNotNull((Object)offset, (String)"Offset cannot be null");
    }

    public void setResultIfMissing(boolean flag) {
        this.resultIfMissing = flag;
    }

    @Override
    protected boolean allowNullAttributeContext() {
        return this.resultIfMissing;
    }

    @Override
    protected boolean hasMatch(@Nonnull @NonnullElements Map<String, IdPAttribute> attributeMap) {
        IdPAttribute attribute = attributeMap.get(this.attributeName);
        if (attribute == null) {
            this.log.debug("Attribute {} not found in context, returning {}", (Object)this.attributeName, (Object)this.resultIfMissing);
            return this.resultIfMissing;
        }
        if (attribute.getValues().isEmpty()) {
            this.log.debug("Attribute {} has no values, returning {}", (Object)this.attributeName, (Object)this.resultIfMissing);
            return this.resultIfMissing;
        }
        Instant now = Instant.now();
        for (IdPAttributeValue value : attribute.getValues()) {
            if (!(value instanceof StringAttributeValue)) continue;
            String dateString = ((StringAttributeValue)value).getValue();
            try {
                if (!(this.dateTimeFormatter != null ? Instant.from(this.dateTimeFormatter.parse(dateString)).plus(this.systemTimeOffset).isAfter(now) : this.legacyFormatter.parseDateTime(dateString).plus(this.systemTimeOffset.toMillis()).isAfterNow())) continue;
                return true;
            }
            catch (RuntimeException e) {
                this.log.warn("{} is not a valid date for the configured date parser", (Object)dateString, (Object)e);
            }
        }
        return false;
    }
}

