/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MovingAverages;
import com.codahale.metrics.SlidingTimeWindowMovingAverages;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.metrics.MetricsSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopDetectionPredicate
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LoopDetectionPredicate.class);
    private long threshold = 20L;
    @Nonnull
    @NonnullElements
    private Map<String, String> relyingPartyMap = Collections.emptyMap();
    @Nonnull
    private Function<ProfileRequestContext, String> usernameLookupStrategy = FunctionSupport.constant(null);

    public void setThreshold(@Positive long value) {
        this.threshold = Constraint.isGreaterThan((long)0L, (long)value, (String)"Threshold must be positive");
    }

    public void setRelyingPartyMap(@Nullable @NonnullElements Map<String, String> map) {
        this.relyingPartyMap = map != null ? Map.copyOf(map) : Collections.emptyMap();
    }

    public void setUsernameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.usernameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Username lookup strategy cannot be null");
    }

    public boolean test(@Nullable ProfileRequestContext input) {
        String meterName;
        String username = this.usernameLookupStrategy.apply(input);
        RelyingPartyContext rpCtx = this.getRelyingPartyContextLookupStrategy().apply(input);
        if (username != null && rpCtx != null && rpCtx.getRelyingPartyId() != null && (meterName = this.relyingPartyMap.get(rpCtx.getRelyingPartyId())) != null) {
            meterName = MetricRegistry.name((String)"net.shibboleth.idp.loopDetection", (String[])new String[]{meterName, username.replace(".", "")});
            Meter meter = MetricsSupport.getMetricRegistry().meter(meterName, (MetricRegistry.MetricSupplier)new MetricRegistry.MetricSupplier<Meter>(){

                public Meter newMetric() {
                    return new Meter((MovingAverages)new SlidingTimeWindowMovingAverages());
                }
            });
            meter.mark();
            double rate = meter.getOneMinuteRate();
            if (rate > (double)this.threshold) {
                this.log.warn("Meter {} rate of {} exceeded threshold of {}", new Object[]{meterName, rate, this.threshold});
                return true;
            }
        }
        return false;
    }
}

