/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProfileConfiguration
extends AbstractIdentifiableInitializableComponent
implements ProfileConfiguration {
    @Nonnull
    public static final Integer DEFAULT_DISALLOWED_FEATURES = 0;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractProfileConfiguration.class);
    @Nonnull
    private Function<ProfileRequestContext, List<String>> inboundFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, List<String>> outboundFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, SecurityConfiguration> securityConfigurationLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Integer> disallowedFeaturesLookupStrategy;

    public AbstractProfileConfiguration(@Nonnull @ParameterName(name="id") @NotEmpty String id) {
        this.setId(id);
        this.securityConfigurationLookupStrategy = FunctionSupport.constant(null);
        this.inboundFlowsLookupStrategy = FunctionSupport.constant(null);
        this.outboundFlowsLookupStrategy = FunctionSupport.constant(null);
        this.disallowedFeaturesLookupStrategy = FunctionSupport.constant((Object)DEFAULT_DISALLOWED_FEATURES);
    }

    @Override
    @Nullable
    public SecurityConfiguration getSecurityConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        return this.securityConfigurationLookupStrategy.apply(profileRequestContext);
    }

    public void setSecurityConfiguration(@Nullable SecurityConfiguration configuration) {
        this.securityConfigurationLookupStrategy = FunctionSupport.constant((Object)configuration);
    }

    public void setSecurityConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityConfiguration> strategy) {
        this.securityConfigurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getInboundInterceptorFlows(@Nullable ProfileRequestContext profileRequestContext) {
        List<String> flows = this.inboundFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return List.copyOf(flows);
        }
        return Collections.emptyList();
    }

    public void setInboundInterceptorFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.inboundFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    @Deprecated(since="4.2.0", forRemoval=true)
    public void setInboundFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setInboundFlowsLookupStrategy", (String)"relying-party.xml", (String)"setInboundInterceptorFlowsLookupStrategy");
        this.setInboundInterceptorFlowsLookupStrategy(strategy);
    }

    public void setInboundInterceptorFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.inboundFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getOutboundInterceptorFlows(@Nullable ProfileRequestContext profileRequestContext) {
        List<String> flows = this.outboundFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return List.copyOf(flows);
        }
        return Collections.emptyList();
    }

    public void setOutboundInterceptorFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.outboundFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    @Deprecated(since="4.2.0", forRemoval=true)
    public void setOutboundFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setOutboundFlowsLookupStrategy", (String)"relying-party.xml", (String)"setOutboundInterceptorFlowsLookupStrategy");
        this.outboundFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setOutboundInterceptorFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.outboundFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isFeatureDisallowed(@Nullable ProfileRequestContext profileRequestContext, int feature) {
        return (this.getDisallowedFeatures(profileRequestContext) & feature) == feature;
    }

    public int getDisallowedFeatures(@Nullable ProfileRequestContext profileRequestContext) {
        Integer mask = this.disallowedFeaturesLookupStrategy.apply(profileRequestContext);
        return mask != null ? mask : DEFAULT_DISALLOWED_FEATURES;
    }

    public void setDisallowedFeatures(int mask) {
        this.disallowedFeaturesLookupStrategy = FunctionSupport.constant((Object)mask);
    }

    public void setDisallowedFeaturesLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.disallowedFeaturesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractProfileConfiguration)) {
            return false;
        }
        AbstractProfileConfiguration other = (AbstractProfileConfiguration)obj;
        return Objects.equals(this.getId(), other.getId());
    }
}

