/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.interceptor.AbstractProfileInterceptorResult;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractProfileInterceptorResultTest {
    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmptyContext() {
        new MockAbstractProfileInterceptorResult("", "key", "value", Instant.ofEpochMilli(100L));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmptyKey() {
        new MockAbstractProfileInterceptorResult("context", "", "value", Instant.ofEpochMilli(100L));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmptyValue() {
        new MockAbstractProfileInterceptorResult("context", "key", "", Instant.ofEpochMilli(100L));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNegativeExpiration() {
        new MockAbstractProfileInterceptorResult("context", "key", "value", Instant.ofEpochMilli(-100L));
    }

    @Test
    public void testNullExpiration() {
        MockAbstractProfileInterceptorResult result = new MockAbstractProfileInterceptorResult("context", "key", "value", null);
        Assert.assertEquals((String)result.getStorageContext(), (String)"context");
        Assert.assertEquals((String)result.getStorageKey(), (String)"key");
        Assert.assertEquals((String)result.getStorageValue(), (String)"value");
        Assert.assertEquals((Object)result.getStorageExpiration(), null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testZeroExpiration() {
        new MockAbstractProfileInterceptorResult("context", "key", "value", Instant.ofEpochMilli(0L));
    }

    @Test
    public void testResult() {
        MockAbstractProfileInterceptorResult result = new MockAbstractProfileInterceptorResult("context", "key", "value", Instant.ofEpochMilli(100L));
        Assert.assertEquals((String)result.getStorageContext(), (String)"context");
        Assert.assertEquals((String)result.getStorageKey(), (String)"key");
        Assert.assertEquals((String)result.getStorageValue(), (String)"value");
        Assert.assertEquals((Object)result.getStorageExpiration(), (Object)Instant.ofEpochMilli(100L));
    }

    private class MockAbstractProfileInterceptorResult
    extends AbstractProfileInterceptorResult {
        public MockAbstractProfileInterceptorResult(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable String value, Instant expiration) {
            super(context, key, value, expiration);
        }
    }
}

