/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public final class MultiRelyingPartyContext
extends BaseContext {
    @Nonnull
    private Map<String, RelyingPartyContext> relyingPartyIdMap = new HashMap<String, RelyingPartyContext>();
    @Nonnull
    private ListMultimap<String, RelyingPartyContext> relyingPartyLabelMap = ArrayListMultimap.create();
    @Nullable
    private Iterator<RelyingPartyContext> relyingPartyIterator;

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<RelyingPartyContext> getRelyingPartyContexts() {
        return CollectionSupport.copyToList(this.relyingPartyIdMap.values());
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<RelyingPartyContext> getRelyingPartyContexts(@Nonnull @NotEmpty String label) {
        return CollectionSupport.copyToList((Collection)this.relyingPartyLabelMap.get((Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)label), (String)"Label cannot be null or empty"))));
    }

    @Nullable
    public RelyingPartyContext getRelyingPartyContextById(@Nonnull @NotEmpty String id) {
        return this.relyingPartyIdMap.get(Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"ID cannot be null or empty"));
    }

    @Nonnull
    public Iterator<RelyingPartyContext> getRelyingPartyContextIterator(boolean fresh) {
        if (fresh || this.relyingPartyIterator == null) {
            this.relyingPartyIterator = new RelyingPartyContextIterator(this);
        }
        assert (this.relyingPartyIterator != null);
        return this.relyingPartyIterator;
    }

    @Nonnull
    public Iterator<RelyingPartyContext> getRelyingPartyContextIterator() {
        return this.getRelyingPartyContextIterator(false);
    }

    @Nullable
    public RelyingPartyContext getCurrentRelyingPartyContext() {
        if (this.relyingPartyIterator != null) {
            return ((RelyingPartyContextIterator)this.relyingPartyIterator).current;
        }
        return null;
    }

    public void addRelyingPartyContext(@Nonnull @NotEmpty String label, @Nonnull RelyingPartyContext context) {
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)label), (String)"Label cannot be null or empty");
        Constraint.isNotNull((Object)context, (String)"Context cannot be null");
        Constraint.isNotNull((Object)context.getRelyingPartyId(), (String)"RelyingParty ID cannot be null");
        this.relyingPartyIdMap.put(context.getRelyingPartyId(), context);
        this.relyingPartyLabelMap.put((Object)trimmed, (Object)context);
    }

    public void removeRelyingPartyContext(@Nonnull @NotEmpty String label, @Nonnull RelyingPartyContext context) {
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)label), (String)"Label cannot be null or empty");
        Constraint.isNotNull((Object)context, (String)"Context cannot be null");
        Constraint.isNotNull((Object)context.getRelyingPartyId(), (String)"RelyingParty ID cannot be null");
        this.relyingPartyIdMap.remove(context.getRelyingPartyId());
        this.relyingPartyLabelMap.remove((Object)trimmed, (Object)context);
    }

    private class RelyingPartyContextIterator
    implements Iterator<RelyingPartyContext> {
        @Nonnull
        private final Iterator<RelyingPartyContext> iterator;
        @Nullable
        private RelyingPartyContext current;

        public RelyingPartyContextIterator(MultiRelyingPartyContext ctx) {
            this.iterator = ctx.relyingPartyIdMap.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public RelyingPartyContext next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            this.current = null;
        }
    }
}

