/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ScriptedAction
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_ENGINE = "JavaScript";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedAction.class);
    @Nonnull
    private final ActionScriptEvaluator scriptEvaluator;

    protected ScriptedAction(@Nonnull EvaluableScript theScript) {
        this.scriptEvaluator = new ActionScriptEvaluator(theScript);
    }

    @Nullable
    public Object getCustomObject() {
        return this.scriptEvaluator.getCustomObject();
    }

    public void setCustomObject(@Nullable Object object) {
        this.checkSetterPreconditions();
        this.scriptEvaluator.setCustomObject(object);
    }

    public void setHideExceptions(boolean flag) {
        this.checkSetterPreconditions();
        this.scriptEvaluator.setHideExceptions(flag);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.scriptEvaluator.setLogPrefix(this.getLogPrefix());
    }

    public void doExecute(@Nonnull ProfileRequestContext profileContext) {
        String result = this.scriptEvaluator.execute(profileContext);
        if (result == null) {
            this.log.debug("{} signaled proceed event", (Object)this.getLogPrefix());
            ActionSupport.buildProceedEvent((ProfileRequestContext)profileContext);
        } else {
            this.log.debug("{} signaled event: {}", (Object)this.getLogPrefix(), (Object)result);
            ActionSupport.buildEvent((ProfileRequestContext)profileContext, (String)result);
        }
    }

    @Nonnull
    public static ScriptedAction resourceScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(resource);
        script.initialize();
        return new ScriptedAction(script);
    }

    @Nonnull
    public static ScriptedAction resourceScript(@Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedAction.resourceScript(DEFAULT_ENGINE, resource);
    }

    @Nonnull
    public static ScriptedAction inlineScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedAction(script);
    }

    @Nonnull
    public static ScriptedAction inlineScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        return ScriptedAction.inlineScript(DEFAULT_ENGINE, scriptSource);
    }

    private class ActionScriptEvaluator
    extends AbstractScriptEvaluator {
        public ActionScriptEvaluator(EvaluableScript theScript) {
            super(theScript);
            this.setOutputType(String.class);
            this.setReturnOnError("InvalidProfileContext");
        }

        @Nullable
        public Object getCustomObject() {
            return super.getCustomObject();
        }

        @Nullable
        public String execute(@Nullable ProfileRequestContext profileContext) {
            return (String)this.evaluate(new Object[]{profileContext});
        }

        protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
            scriptContext.setAttribute("profileContext", input != null ? input[0] : null, 100);
        }
    }
}

