/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.InterceptorAwareProfileConfiguration;
import net.shibboleth.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractInterceptorAwareProfileConfiguration
extends AbstractConditionalProfileConfiguration
implements InterceptorAwareProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, List<String>> inboundFlowsLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, List<String>> outboundFlowsLookupStrategy = FunctionSupport.constant(null);

    public AbstractInterceptorAwareProfileConfiguration(@Nonnull @ParameterName(name="id") @NotEmpty String id) {
        super(id);
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getInboundInterceptorFlows(@Nullable ProfileRequestContext profileRequestContext) {
        List<String> flows = this.inboundFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToList(flows);
        }
        return CollectionSupport.emptyList();
    }

    public void setInboundInterceptorFlows(@Nullable Collection<String> flows) {
        this.inboundFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setInboundInterceptorFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.inboundFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getOutboundInterceptorFlows(@Nullable ProfileRequestContext profileRequestContext) {
        List<String> flows = this.outboundFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToList(flows);
        }
        return CollectionSupport.emptyList();
    }

    public void setOutboundInterceptorFlows(@Nullable Collection<String> flows) {
        this.outboundFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setOutboundInterceptorFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.outboundFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

