/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.springframework.webflow.execution.Event;

public class SpringEventToViewLookupFunction
implements Function<Event, String> {
    @Nullable
    private String defaultView;
    @Nonnull
    private Map<String, String> eventMap = CollectionSupport.emptyMap();

    public void setDefaultView(@Nullable String view) {
        this.defaultView = StringSupport.trimOrNull((String)view);
    }

    public void setEventMap(@Nullable Map<String, String> map) {
        if (map == null) {
            this.eventMap = CollectionSupport.emptyMap();
        } else {
            this.eventMap = new HashMap<String, String>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String eventId = StringSupport.trimOrNull((String)entry.getKey());
                String viewName = StringSupport.trimOrNull((String)entry.getValue());
                if (eventId == null || viewName == null) continue;
                this.eventMap.put(eventId, viewName);
            }
        }
    }

    @Override
    @Nullable
    public String apply(@Nullable Event input) {
        if (input != null) {
            String view = this.eventMap.get(input.getId());
            return view != null ? view : this.defaultView;
        }
        return null;
    }
}

