/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractConditionalProfileAction;
import org.opensaml.profile.action.ProfileAction;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@ThreadSafe
public abstract class AbstractProfileAction
extends AbstractConditionalProfileAction
implements Action,
MessageSource,
MessageSourceAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractProfileAction.class);
    @Nonnull
    private Function<RequestContext, ProfileRequestContext> profileContextLookupStrategy = new WebflowRequestContextProfileRequestContextLookup();
    @Nullable
    private MessageSource messageSource;

    @Nonnull
    public Function<RequestContext, ProfileRequestContext> getProfileContextLookupStrategy() {
        return this.profileContextLookupStrategy;
    }

    public void setProfileContextLookupStrategy(@Nonnull Function<RequestContext, ProfileRequestContext> strategy) {
        this.checkSetterPreconditions();
        this.profileContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    @Nullable
    public Event execute(@Nullable RequestContext springRequestContext) {
        this.checkComponentActive();
        if (springRequestContext == null) {
            this.log.error("{} Spring request context is not available", (Object)this.getLogPrefix());
            return ActionSupport.buildEvent((Object)this, "InvalidProfileContext");
        }
        ProfileRequestContext profileRequestContext = this.profileContextLookupStrategy.apply(springRequestContext);
        if (profileRequestContext == null) {
            this.log.error("{} ProfileEequestContext is not available", (Object)this.getLogPrefix());
            return ActionSupport.buildEvent((Object)this, "InvalidProfileContext");
        }
        return this.doExecute(springRequestContext, profileRequestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        SpringRequestContext springSubcontext = (SpringRequestContext)profileRequestContext.ensureSubcontext(SpringRequestContext.class);
        assert (springSubcontext != null);
        springSubcontext.setRequestContext(springRequestContext);
        try {
            this.execute(profileRequestContext);
        }
        finally {
            profileRequestContext.removeSubcontext((BaseContext)springSubcontext);
        }
        return this.getResult((ProfileAction)this, profileRequestContext);
    }

    @Nullable
    protected Event getResult(@Nonnull ProfileAction action, @Nonnull ProfileRequestContext profileRequestContext) {
        EventContext eventCtx = (EventContext)profileRequestContext.getSubcontext(EventContext.class);
        if (eventCtx != null) {
            Object event = eventCtx.getEvent();
            if (event instanceof Event) {
                Event e = (Event)event;
                return e;
            }
            if (event instanceof String) {
                String e = (String)event;
                return ActionSupport.buildEvent(action, e);
            }
            if (event instanceof AttributeMap) {
                AttributeMap map = (AttributeMap)event;
                return ActionSupport.buildEvent(action, map.getString("eventId", "proceed"), (AttributeMap<Object>)map);
            }
        }
        return null;
    }

    @Nullable
    protected <T> T getBean(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String name, @Nonnull Class<T> claz) {
        SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springRequestContext == null) {
            this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
            return null;
        }
        RequestContext requestContext = springRequestContext.getRequestContext();
        if (requestContext == null) {
            this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
            return null;
        }
        return this.getBean(requestContext, name, claz);
    }

    @Nullable
    protected <T> T getBean(@Nonnull RequestContext flowRequestContext, @Nonnull @NotEmpty String name, @Nonnull Class<T> claz) {
        try {
            Object bean = flowRequestContext.getActiveFlow().getApplicationContext().getBean(name);
            if (bean != null && claz.isInstance(bean)) {
                return claz.cast(bean);
            }
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        this.log.warn("{} No bean of the correct type found named {}", (Object)this.getLogPrefix(), (Object)name);
        return null;
    }

    @Nullable
    protected <T> T getParameter(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String name) {
        SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springRequestContext == null) {
            this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
            return null;
        }
        RequestContext requestContext = springRequestContext.getRequestContext();
        if (requestContext == null) {
            this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
            return null;
        }
        return this.getParameter(requestContext, name);
    }

    @Nullable
    protected <T> T getParameter(@Nonnull RequestContext flowRequestContext, @Nonnull @NotEmpty String name) {
        MutableAttributeMap scope = flowRequestContext.getFlowScope();
        if (scope != null && scope.contains(name)) {
            return (T)scope.get(name);
        }
        scope = flowRequestContext.getConversationScope();
        if (scope != null && scope.contains(name)) {
            return (T)scope.get(name);
        }
        return null;
    }

    public void setMessageSource(@Nullable MessageSource source) {
        this.messageSource = source;
    }

    @Nullable
    public String getMessage(@Nonnull String code, @Nullable Object[] args, @Nullable String defaultMessage, @Nullable Locale locale) {
        if (this.messageSource != null) {
            return this.messageSource.getMessage(code, args, defaultMessage, locale);
        }
        return MessageFormat.format(defaultMessage, args);
    }

    @Nonnull
    public String getMessage(@Nonnull String code, @Nullable Object[] args, @Nullable Locale locale) {
        if (this.messageSource != null) {
            return this.messageSource.getMessage(code, args, locale);
        }
        throw new NoSuchMessageException("MessageSource was not set");
    }

    @Nonnull
    public String getMessage(@Nonnull MessageSourceResolvable resolvable, @Nullable Locale locale) {
        if (this.messageSource != null) {
            return this.messageSource.getMessage(resolvable, locale);
        }
        throw new NoSuchMessageException("MessageSource was not set");
    }

    @Nullable
    protected RequestContext getRequestContext(@Nonnull ProfileRequestContext profileRequestContext) {
        SpringRequestContext springRequestCtx = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springRequestCtx == null) {
            return null;
        }
        return springRequestCtx.getRequestContext();
    }
}

