/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectProfileConfiguration
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectProfileConfiguration.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nullable
    private RelyingPartyContext rpCtx;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.rpCtx = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.rpCtx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (this.rpCtx.getConfiguration() == null) {
            this.log.debug("{} No relying party configuration associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String profileId = profileRequestContext.getProfileId();
        RelyingPartyConfiguration rpConfig = this.rpCtx.getConfiguration();
        ProfileConfiguration profileConfiguration = rpConfig.getProfileConfiguration(profileId);
        if (profileConfiguration == null) {
            this.log.warn("{} Profile {} is not available for RP configuration {} (RPID {})", new Object[]{this.getLogPrefix(), profileId, rpConfig.getId(), this.rpCtx.getRelyingPartyId()});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return;
        }
        this.rpCtx.setProfileConfig(profileConfiguration);
    }
}

