/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.audit.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class AttributesAuditExtractor
implements Function<ProfileRequestContext, Collection<String>> {
    private boolean useUnfiltered;
    @Nullable
    private Predicate<ProfileRequestContext> activationCondition;
    @Nonnull
    private final Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;

    public AttributesAuditExtractor() {
        this.attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    }

    public AttributesAuditExtractor(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setUseUnfiltered(boolean flag) {
        this.useUnfiltered = flag;
    }

    public void setActivationCondition(@Nullable Predicate<ProfileRequestContext> condition) {
        this.activationCondition = condition;
    }

    @Override
    @Nullable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        if (this.activationCondition != null && !this.activationCondition.test(input)) {
            return Collections.emptyList();
        }
        AttributeContext attributeCtx = this.attributeContextLookupStrategy.apply(input);
        if (attributeCtx != null) {
            return (this.useUnfiltered ? attributeCtx.getUnfilteredIdPAttributes() : attributeCtx.getIdPAttributes()).keySet();
        }
        return Collections.emptyList();
    }
}

