/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectContextPrincipalLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RootContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.ProxiedRequesterContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterAttributes
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterAttributes.class);
    @Nonnull
    private final ReloadableService<AttributeFilter> attributeFilterService;
    @Nullable
    private MetadataResolver metadataResolver;
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> recipientLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeFilterContext> filterContextCreationStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> principalNameLookupStrategy;
    @Nonnull
    private Function<AttributeFilterContext, ProfileRequestContext> profileRequestContextFromFilterLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, SAMLMetadataContext> issuerMetadataContextLookupStrategy;
    @Nullable
    private Function<AttributeFilterContext, SAMLMetadataContext> issuerMetadataFromFilterLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy;
    @Nullable
    private Function<AttributeFilterContext, SAMLMetadataContext> metadataFromFilterLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, ProxiedRequesterContext> proxiedRequesterContextLookupStrategy;
    @Nullable
    private Function<AttributeFilterContext, ProxiedRequesterContext> proxiesFromFilterLookupStrategy;
    private boolean maskFailures;
    @Nullable
    private AttributeContext attributeContext;

    public FilterAttributes(@Nonnull ReloadableService<AttributeFilter> filterService) {
        this.attributeFilterService = (ReloadableService)Constraint.isNotNull(filterService, (String)"Service cannot be null");
        this.issuerLookupStrategy = new ResponderIdLookupFunction();
        this.recipientLookupStrategy = new RelyingPartyIdLookupFunction();
        this.attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        this.principalNameLookupStrategy = new SubjectContextPrincipalLookupFunction().compose((Function)new ChildContextLookup(SubjectContext.class));
        this.profileRequestContextFromFilterLookupStrategy = new RootContextLookup(ProfileRequestContext.class);
        this.metadataContextLookupStrategy = new ChildContextLookup(SAMLMetadataContext.class).compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new InboundMessageContextLookup()));
        this.metadataFromFilterLookupStrategy = this.metadataContextLookupStrategy.compose(this.profileRequestContextFromFilterLookupStrategy);
        this.proxiedRequesterContextLookupStrategy = new ChildContextLookup(ProxiedRequesterContext.class).compose((Function)new InboundMessageContextLookup());
        this.proxiesFromFilterLookupStrategy = this.proxiedRequesterContextLookupStrategy.compose(this.profileRequestContextFromFilterLookupStrategy);
        this.filterContextCreationStrategy = new ChildContextLookup(AttributeFilterContext.class, true).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        this.maskFailures = true;
    }

    public void setMetadataResolver(@Nullable MetadataResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataResolver = resolver;
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = strategy;
    }

    public void setRecipientLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.recipientLookupStrategy = strategy;
    }

    public void setFilterContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AttributeFilterContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.filterContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext creation strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setPrincipalNameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalNameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Principal name lookup strategy cannot be null");
    }

    public void setIssuerMetadataContextLookupStrategy(@Nullable Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerMetadataContextLookupStrategy = strategy;
        this.issuerMetadataFromFilterLookupStrategy = strategy != null ? this.issuerMetadataContextLookupStrategy.compose(this.profileRequestContextFromFilterLookupStrategy) : null;
    }

    public void setMetadataContextLookupStrategy(@Nullable Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataContextLookupStrategy = strategy;
        this.metadataFromFilterLookupStrategy = strategy != null ? this.metadataContextLookupStrategy.compose(this.profileRequestContextFromFilterLookupStrategy) : null;
    }

    public void setProxiedRequesterContextLookupStrategy(@Nullable Function<ProfileRequestContext, ProxiedRequesterContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.proxiedRequesterContextLookupStrategy = strategy;
        this.proxiesFromFilterLookupStrategy = strategy != null ? this.proxiedRequesterContextLookupStrategy.compose(this.profileRequestContextFromFilterLookupStrategy) : null;
    }

    public void setMaskFailures(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maskFailures = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.attributeContext = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeContext == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        if (this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AttributeFilterContext filterContext = this.filterContextCreationStrategy.apply(profileRequestContext);
        if (filterContext == null) {
            this.log.error("{} Unable to locate or create AttributeFilterContext", (Object)this.getLogPrefix());
            if (this.maskFailures) {
                this.log.warn("Filter error masked, clearing resolved attributes");
                this.attributeContext.setIdPAttributes(null);
            } else {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToFilterAttributes");
            }
            return;
        }
        this.populateFilterContext(profileRequestContext, filterContext);
        ServiceableComponent component = null;
        try {
            component = this.attributeFilterService.getServiceableComponent();
            if (null == component) {
                this.log.error("{} Error encountered while filtering attributes : Invalid Attribute Filter configuration", (Object)this.getLogPrefix());
                if (this.maskFailures) {
                    this.log.warn("Filter error masked, clearing resolved attributes");
                    this.attributeContext.setIdPAttributes(null);
                } else {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToFilterAttributes");
                }
            } else {
                AttributeFilter filter = (AttributeFilter)component.getComponent();
                filter.filterAttributes(filterContext);
                filterContext.getParent().removeSubcontext((BaseContext)filterContext);
                this.attributeContext.setIdPAttributes(filterContext.getFilteredIdPAttributes().values());
            }
        }
        catch (AttributeFilterException e) {
            this.log.error("{} Error encountered while filtering attributes", (Object)this.getLogPrefix(), (Object)e);
            if (this.maskFailures) {
                this.log.warn("Filter error masked, clearing resolved attributes");
                this.attributeContext.setIdPAttributes(Collections.emptySet());
            } else {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToFilterAttributes");
            }
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }

    private void populateFilterContext(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AttributeFilterContext filterContext) {
        filterContext.setDirection(AttributeFilterContext.Direction.OUTBOUND).setMetadataResolver(this.metadataResolver).setPrincipal(this.principalNameLookupStrategy.apply(profileRequestContext)).setAttributeRecipientID(this.recipientLookupStrategy != null ? this.recipientLookupStrategy.apply(profileRequestContext) : null).setAttributeIssuerID(this.issuerLookupStrategy != null ? this.issuerLookupStrategy.apply(profileRequestContext) : null).setIssuerMetadataContextLookupStrategy(this.issuerMetadataFromFilterLookupStrategy).setRequesterMetadataContextLookupStrategy(this.metadataFromFilterLookupStrategy).setProxiedRequesterContextLookupStrategy(this.proxiesFromFilterLookupStrategy);
        if (filterContext.getPrefilteredIdPAttributes().isEmpty()) {
            filterContext.setPrefilteredIdPAttributes(this.attributeContext.getIdPAttributes().values());
        }
    }
}

