/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.MetricContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFlowMessageHandlerAdaptor
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(WebFlowMessageHandlerAdaptor.class);
    @Nullable
    private Function<ProfileRequestContext, MessageHandler> handlerLookupStrategy;
    @Nullable
    private MessageHandler handler;
    private final Direction direction;
    @Nullable
    private String errorEvent;

    private WebFlowMessageHandlerAdaptor(@Nonnull @ParameterName(name="executionDirection") Direction executionDirection) {
        this.direction = (Direction)((Object)Constraint.isNotNull((Object)((Object)executionDirection), (String)"Execution direction cannot be null"));
    }

    public WebFlowMessageHandlerAdaptor(@Nonnull @ParameterName(name="messageHandler") MessageHandler messageHandler, @Nonnull @ParameterName(name="executionDirection") Direction executionDirection) {
        this(executionDirection);
        this.handler = (MessageHandler)Constraint.isNotNull((Object)messageHandler, (String)"MessageHandler cannot be null");
    }

    public WebFlowMessageHandlerAdaptor(@Nonnull @ParameterName(name="lookupStrategy") Function<ProfileRequestContext, MessageHandler> lookupStrategy, @Nonnull @ParameterName(name="executionDirection") Direction executionDirection) {
        this(executionDirection);
        this.handlerLookupStrategy = (Function)Constraint.isNotNull(lookupStrategy, (String)"MessageHandler lookup strategy cannot be null");
    }

    public void setErrorEvent(@Nullable String event) {
        this.errorEvent = StringSupport.trimOrNull((String)event);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricContext metricCtx;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.handler == null) {
            this.handler = this.handlerLookupStrategy.apply(profileRequestContext);
            if (this.handler == null) {
                this.log.debug("{} No message handler returned by lookup function, nothing to do", (Object)this.getLogPrefix());
                return false;
            }
        }
        if ((metricCtx = (MetricContext)profileRequestContext.getSubcontext(MetricContext.class)) != null) {
            metricCtx.start(this.handler.getClass().getSimpleName());
        }
        return true;
    }

    public void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext target = null;
        switch (this.direction) {
            case INBOUND: {
                target = profileRequestContext.getInboundMessageContext();
                this.log.debug("{} Invoking message handler of type '{}' on INBOUND message context", (Object)this.getLogPrefix(), (Object)this.handler.getClass().getName());
                break;
            }
            case OUTBOUND: {
                target = profileRequestContext.getOutboundMessageContext();
                this.log.debug("{} Invoking message handler of type '{}' on OUTBOUND message context", (Object)this.getLogPrefix(), (Object)this.handler.getClass().getName());
                break;
            }
            default: {
                this.log.warn("{} Specified direction '{}' was unknown, skipping handler invocation", (Object)this.getLogPrefix(), (Object)this.direction);
                return;
            }
        }
        if (target == null) {
            this.log.warn("{} Target message context was null, cannot invoke handler", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        if (target.getMessage() != null) {
            this.log.debug("{} Invoking message handler on message context containing a message of type '{}'", (Object)this.getLogPrefix(), (Object)target.getMessage().getClass().getName());
        }
        try {
            this.handler.invoke(target);
        }
        catch (MessageHandlerException e) {
            this.log.warn("{} Exception handling message", (Object)this.getLogPrefix(), (Object)e);
            if (this.errorEvent != null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.errorEvent);
            }
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
        }
    }

    protected void doPostExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricContext metricCtx = (MetricContext)profileRequestContext.getSubcontext(MetricContext.class);
        if (metricCtx != null) {
            String name = this.handler.getClass().getSimpleName();
            metricCtx.stop(name);
            metricCtx.inc(name);
        }
        super.doPostExecute(profileRequestContext);
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

