/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.support;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;

public class PathInfoSupportingFlowUrlHandler
extends DefaultFlowUrlHandler {
    @Nonnull
    @NonnullElements
    private Collection<String> supportedFlowIds = Collections.emptyList();

    public void setSupportedFlows(@Nonnull @NonnullElements Collection<String> flowIds) {
        this.supportedFlowIds = StringSupport.normalizeStringCollection(flowIds);
    }

    public String getFlowId(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            for (String id : this.supportedFlowIds) {
                if (!pathInfo.startsWith(id, 1) || pathInfo.length() <= id.length() + 1 || pathInfo.charAt(id.length() + 1) != '/') continue;
                return id;
            }
        }
        return super.getFlowId(request);
    }
}

