/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.logic.VerifiedProfilePredicate;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRelyingPartyConfigurationResolver
extends AbstractServiceableComponent<RelyingPartyConfigurationResolver>
implements RelyingPartyConfigurationResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultRelyingPartyConfigurationResolver.class);
    @Nonnull
    private List<RelyingPartyConfiguration> rpConfigurations = Collections.emptyList();
    @Nullable
    private RelyingPartyConfiguration unverifiedConfiguration;
    @NonnullAfterInit
    private RelyingPartyConfiguration defaultConfiguration;
    @NonnullAfterInit
    private Predicate<ProfileRequestContext> verificationPredicate = new VerifiedProfilePredicate();
    @Nullable
    private SecurityConfiguration defaultSecurityConfiguration;
    @Nullable
    private List<Credential> signingCredentials = Collections.emptyList();
    @Nullable
    private List<Credential> encryptionCredentials = Collections.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<RelyingPartyConfiguration> getRelyingPartyConfigurations() {
        return this.rpConfigurations;
    }

    public void setRelyingPartyConfigurations(@Nonnull @NonnullElements List<RelyingPartyConfiguration> configs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.rpConfigurations = List.copyOf((Collection)Constraint.isNotNull(configs, (String)"RelyingPartyConfiguration list cannot be null"));
    }

    @NonnullAfterInit
    public RelyingPartyConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public void setDefaultConfiguration(@Nonnull RelyingPartyConfiguration configuration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultConfiguration = (RelyingPartyConfiguration)Constraint.isNotNull((Object)configuration, (String)"Default RP configuration cannot be null");
    }

    @NonnullAfterInit
    public RelyingPartyConfiguration getUnverifiedConfiguration() {
        return this.unverifiedConfiguration;
    }

    public void setUnverifiedConfiguration(@Nonnull RelyingPartyConfiguration configuration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.unverifiedConfiguration = (RelyingPartyConfiguration)Constraint.isNotNull((Object)configuration, (String)"Unverified RP configuration cannot be null");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getVerificationPredicate() {
        return this.verificationPredicate;
    }

    public void setVerificationPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.verificationPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Verification predicate cannot be null");
    }

    public void setDefaultSecurityConfiguration(@Nullable SecurityConfiguration config) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultSecurityConfiguration = config;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        HashSet<String> configIds = new HashSet<String>(this.rpConfigurations.size());
        for (RelyingPartyConfiguration config : this.rpConfigurations) {
            if (configIds.contains(config.getId())) {
                throw new ComponentInitializationException("Multiple replying party configurations with ID " + config.getId() + " detected. Configuration IDs must be unique.");
            }
            configIds.add(config.getId());
        }
    }

    @Nonnull
    @NonnullElements
    public Iterable<RelyingPartyConfiguration> resolve(@Nullable ProfileRequestContext context) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (context == null) {
            return Collections.emptyList();
        }
        this.log.debug("Resolving relying party configuration");
        if (!this.verificationPredicate.test(context)) {
            if (this.getUnverifiedConfiguration() == null) {
                this.log.warn("Profile request was unverified, but no such configuration is available");
                return Collections.emptyList();
            }
            this.log.debug("Profile request is unverified, returning configuration {}", (Object)this.getUnverifiedConfiguration().getId());
            return Collections.singleton(this.getUnverifiedConfiguration());
        }
        ArrayList<RelyingPartyConfiguration> matches = new ArrayList<RelyingPartyConfiguration>();
        for (RelyingPartyConfiguration configuration : this.rpConfigurations) {
            this.log.debug("Checking if relying party configuration {} is applicable", (Object)configuration.getId());
            if (configuration.test(context)) {
                this.log.debug("Relying party configuration {} is applicable", (Object)configuration.getId());
                matches.add(configuration);
                continue;
            }
            this.log.debug("Relying party configuration {} is not applicable", (Object)configuration.getId());
        }
        if (matches.isEmpty()) {
            this.log.debug("No matching Relying Party Configuration found, returning the default configuration {}", (Object)this.getDefaultConfiguration().getId());
            return Collections.singleton(this.getDefaultConfiguration());
        }
        return matches;
    }

    @Nullable
    public RelyingPartyConfiguration resolveSingle(@Nullable ProfileRequestContext context) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (context == null) {
            return null;
        }
        this.log.debug("Resolving relying party configuration");
        if (!this.verificationPredicate.test(context)) {
            if (this.getUnverifiedConfiguration() == null) {
                this.log.warn("Profile request was unverified, but no such configuration is available");
                return null;
            }
            this.log.debug("Profile request is unverified, returning configuration {}", (Object)this.getUnverifiedConfiguration().getId());
            return this.getUnverifiedConfiguration();
        }
        for (RelyingPartyConfiguration configuration : this.rpConfigurations) {
            this.log.debug("Checking if relying party configuration {} is applicable", (Object)configuration.getId());
            if (configuration.test(context)) {
                this.log.debug("Relying party configuration {} is applicable", (Object)configuration.getId());
                return configuration;
            }
            this.log.debug("Relying party configuration {} is not applicable", (Object)configuration.getId());
        }
        this.log.debug("No relying party configurations are applicable, returning the default configuration {}", (Object)this.getDefaultConfiguration().getId());
        return this.getDefaultConfiguration();
    }

    @Nullable
    public SecurityConfiguration getDefaultSecurityConfiguration(@Nonnull @NotEmpty String profileId) {
        return this.defaultSecurityConfiguration;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Credential> getSigningCredentials() {
        return this.signingCredentials;
    }

    public void setSigningCredentials(@Nullable @NonnullElements List<Credential> credentials) {
        this.signingCredentials = credentials != null ? List.copyOf(credentials) : Collections.emptyList();
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Credential> getEncryptionCredentials() {
        return this.encryptionCredentials;
    }

    public void setEncryptionCredentials(@Nullable @NonnullElements List<Credential> credentials) {
        this.encryptionCredentials = credentials != null ? List.copyOf(credentials) : Collections.emptyList();
    }

    @Nonnull
    public RelyingPartyConfigurationResolver getComponent() {
        return this;
    }
}

