/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.audit.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.AuditContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WriteAuditLog
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(WriteAuditLog.class);
    @Nonnull
    private Function<ProfileRequestContext, AuditContext> auditContextLookupStrategy = new ChildContextLookup(AuditContext.class);
    @Nonnull
    @NotEmpty
    private Map<String, List<String>> formattingMap = CollectionSupport.emptyMap();
    @Nonnull
    @NotEmpty
    private Collection<String> categoriesToLog = CollectionSupport.emptyList();
    @Nonnull
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_INSTANT;
    private boolean useDefaultTimeZone;
    private boolean includeProfileLoggingId = true;
    @Nullable
    private RequestContext requestContext;
    @Nullable
    private AuditContext auditCtx;

    public void setAuditContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AuditContext> strategy) {
        this.checkSetterPreconditions();
        this.auditContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuditContext lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Map<String, List<String>> getFormattingMap() {
        return CollectionSupport.copyToMap(this.formattingMap);
    }

    public void setFormattingMap(@Nullable Map<String, String> map) {
        this.checkSetterPreconditions();
        if (map == null) {
            this.formattingMap = CollectionSupport.emptyMap();
            return;
        }
        this.formattingMap = new HashMap<String, List<String>>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String category = StringSupport.trimOrNull((String)entry.getKey());
            String s = StringSupport.trimOrNull((String)entry.getValue());
            if (category == null || s == null) continue;
            int len = s.length();
            boolean inToken = false;
            ArrayList<String> format = new ArrayList<String>();
            StringBuilder field = new StringBuilder();
            for (int pos = 0; pos < len; ++pos) {
                char ch = s.charAt(pos);
                if (inToken) {
                    if (!Character.isLetterOrDigit(ch) && ch != '-' && ch != '%') {
                        format.add(field.toString());
                        field.setLength(0);
                        inToken = false;
                    }
                } else if (ch == '%') {
                    if (field.length() > 0) {
                        format.add(field.toString());
                        field.setLength(0);
                    }
                    inToken = true;
                }
                field.append(ch);
            }
            if (field.length() > 0) {
                format.add(field.toString());
            }
            this.formattingMap.put(category, format);
        }
    }

    public void setCategoriesToLog(@Nullable Collection<String> categories) {
        this.checkSetterPreconditions();
        this.categoriesToLog = categories != null ? CollectionSupport.copyToList(categories) : CollectionSupport.emptyList();
    }

    public void setDateTimeFormat(@Nullable @NotEmpty String format) {
        this.checkSetterPreconditions();
        if (format != null) {
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(StringSupport.trimOrNull((String)format));
        }
    }

    public void setUseDefaultTimeZone(boolean flag) {
        this.checkSetterPreconditions();
        this.useDefaultTimeZone = flag;
    }

    public void setIncludeProfileLoggingId(boolean flag) {
        this.checkSetterPreconditions();
        this.includeProfileLoggingId = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.dateTimeFormatter = this.useDefaultTimeZone ? this.dateTimeFormatter.withZone(ZoneId.systemDefault()) : this.dateTimeFormatter.withZone(ZoneOffset.UTC);
    }

    @Nullable
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        this.requestContext = springRequestContext;
        return super.doExecute(springRequestContext, profileRequestContext);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.formattingMap.isEmpty()) {
            this.log.debug("No formatting for audit records supplied, nothing to do");
            return false;
        }
        this.auditCtx = this.auditContextLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        for (Map.Entry<String, List<String>> entry : this.formattingMap.entrySet()) {
            if (!this.categoriesToLog.isEmpty() && !this.categoriesToLog.contains(entry.getKey())) continue;
            StringBuilder record = new StringBuilder();
            for (String token : entry.getValue()) {
                if (token.startsWith("%")) {
                    if (token.length() == 1 || token.charAt(1) == '%') {
                        record.append('%');
                        continue;
                    }
                    String field = token.substring(1);
                    HttpServletRequest httpRequest = this.getHttpServletRequest();
                    if ("T".equals(field)) {
                        record.append(this.dateTimeFormatter.format(Instant.now()));
                        continue;
                    }
                    if ("e".equals(field)) {
                        assert (this.requestContext != null);
                        Event event = this.requestContext.getCurrentEvent();
                        if (event == null || event.getId().equals("proceed")) continue;
                        record.append(event.getId());
                        continue;
                    }
                    if ("P".equals(field)) {
                        record.append(profileRequestContext.getProfileId());
                        continue;
                    }
                    if ("a".equals(field) && httpRequest != null) {
                        record.append(HttpServletSupport.getRemoteAddr((ServletRequest)httpRequest));
                        continue;
                    }
                    if ("URI".equals(field) && httpRequest != null) {
                        record.append(httpRequest.getRequestURI());
                        continue;
                    }
                    if ("URL".equals(field) && httpRequest != null) {
                        record.append(httpRequest.getRequestURL());
                        continue;
                    }
                    if ("UA".equals(field) && httpRequest != null) {
                        record.append(httpRequest.getHeader("User-Agent"));
                        continue;
                    }
                    if (this.auditCtx == null) continue;
                    assert (field != null);
                    Iterator iter = this.auditCtx.getFieldValues(field).iterator();
                    while (iter.hasNext()) {
                        record.append((String)iter.next());
                        if (!iter.hasNext()) continue;
                        record.append(',');
                    }
                    continue;
                }
                record.append(token);
            }
            this.filter(record);
            Object category = this.includeProfileLoggingId ? entry.getKey() + "." + profileRequestContext.getLoggingId() : entry.getKey();
            assert (category != null);
            LoggerFactory.getLogger((String)category).info(record.toString());
        }
    }

    protected void filter(@Nonnull StringBuilder entry) {
    }
}

