/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.support;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;

public class PathInfoSupportingFlowUrlHandler
extends DefaultFlowUrlHandler {
    @Nonnull
    private Collection<String> supportedFlowIds = CollectionSupport.emptyList();

    public void setSupportedFlows(@Nonnull Collection<String> flowIds) {
        this.supportedFlowIds = StringSupport.normalizeStringCollection(flowIds);
    }

    public String getFlowId(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            for (String id : this.supportedFlowIds) {
                if (!pathInfo.startsWith(id, 1) || pathInfo.length() <= id.length() + 1 || pathInfo.charAt(id.length() + 1) != '/') continue;
                return id;
            }
        }
        return super.getFlowId(request);
    }
}

