/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectContextPrincipalLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RootContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.ProxiedRequesterContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;

public class FilterAttributes
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterAttributes.class);
    @Nonnull
    private final ReloadableService<AttributeFilter> attributeFilterService;
    @Nullable
    private MetadataResolver metadataResolver;
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> recipientLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeFilterContext> filterContextCreationStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> principalNameLookupStrategy;
    @Nonnull
    private Function<AttributeFilterContext, ProfileRequestContext> profileRequestContextFromFilterLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, SAMLMetadataContext> issuerMetadataContextLookupStrategy;
    @Nullable
    private Function<AttributeFilterContext, SAMLMetadataContext> issuerMetadataFromFilterLookupStrategy;
    @Nonnull
    private Function<AttributeFilterContext, SAMLMetadataContext> metadataFromFilterLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, ProxiedRequesterContext> proxiedRequesterContextLookupStrategy;
    @Nonnull
    private Function<AttributeFilterContext, ProxiedRequesterContext> proxiesFromFilterLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, SAMLMetadataContext> proxiedRequesterMetadataLookupStrategy;
    @Nullable
    private Function<AttributeFilterContext, SAMLMetadataContext> proxiedMetadataFromFilterLookupStrategy;
    private boolean maskFailures;
    @NonnullBeforeExec
    private AttributeContext attributeContext;

    public FilterAttributes(@Nonnull ReloadableService<AttributeFilter> filterService) {
        this.attributeFilterService = (ReloadableService)Constraint.isNotNull(filterService, (String)"Service cannot be null");
        this.issuerLookupStrategy = new IssuerLookupFunction();
        this.recipientLookupStrategy = new RelyingPartyIdLookupFunction();
        Function acls = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (acls != null);
        this.attributeContextLookupStrategy = acls;
        Function pnls = new SubjectContextPrincipalLookupFunction().compose((Function)new ChildContextLookup(SubjectContext.class));
        assert (pnls != null);
        this.principalNameLookupStrategy = pnls;
        this.profileRequestContextFromFilterLookupStrategy = new RootContextLookup(ProfileRequestContext.class);
        Function metadataContextLookupStrategy = new ChildContextLookup(SAMLMetadataContext.class).compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new InboundMessageContextLookup()));
        assert (metadataContextLookupStrategy != null);
        Function mffls = metadataContextLookupStrategy.compose(this.profileRequestContextFromFilterLookupStrategy);
        assert (mffls != null);
        this.metadataFromFilterLookupStrategy = mffls;
        Function prcls = new ChildContextLookup(ProxiedRequesterContext.class).compose((Function)new InboundMessageContextLookup());
        assert (prcls != null);
        this.proxiedRequesterContextLookupStrategy = prcls;
        Function<AttributeFilterContext, ProxiedRequesterContext> pffls = this.proxiedRequesterContextLookupStrategy.compose(this.profileRequestContextFromFilterLookupStrategy);
        assert (pffls != null);
        this.proxiesFromFilterLookupStrategy = pffls;
        Function fccs = new ChildContextLookup(AttributeFilterContext.class, true).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (fccs != null);
        this.filterContextCreationStrategy = fccs;
        this.maskFailures = true;
    }

    public void setMetadataResolver(@Nullable MetadataResolver resolver) {
        this.checkSetterPreconditions();
        this.metadataResolver = resolver;
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = strategy;
    }

    public void setRecipientLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.recipientLookupStrategy = strategy;
    }

    public void setFilterContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AttributeFilterContext> strategy) {
        this.checkSetterPreconditions();
        this.filterContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext creation strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.checkSetterPreconditions();
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setPrincipalNameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.principalNameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Principal name lookup strategy cannot be null");
    }

    public void setIssuerMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.issuerMetadataContextLookupStrategy = strategy;
        this.issuerMetadataFromFilterLookupStrategy = strategy != null ? this.issuerMetadataContextLookupStrategy.compose(this.profileRequestContextFromFilterLookupStrategy) : null;
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.checkSetterPreconditions();
        Function<AttributeFilterContext, SAMLMetadataContext> mffls = strategy.compose(this.profileRequestContextFromFilterLookupStrategy);
        assert (mffls != null);
        this.metadataFromFilterLookupStrategy = mffls;
    }

    public void setProxiedRequesterContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ProxiedRequesterContext> strategy) {
        this.checkSetterPreconditions();
        this.proxiedRequesterContextLookupStrategy = strategy;
        Function<AttributeFilterContext, ProxiedRequesterContext> pffls = strategy.compose(this.profileRequestContextFromFilterLookupStrategy);
        assert (pffls != null);
        this.proxiesFromFilterLookupStrategy = pffls;
    }

    public void setProxiedRequesterMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.proxiedRequesterMetadataLookupStrategy = strategy;
        this.proxiedMetadataFromFilterLookupStrategy = strategy != null ? this.proxiedRequesterMetadataLookupStrategy.compose(this.profileRequestContextFromFilterLookupStrategy) : null;
    }

    public void setMaskFailures(boolean flag) {
        this.checkSetterPreconditions();
        this.maskFailures = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.attributeContext = this.attributeContextLookupStrategy.apply(profileRequestContext);
        AttributeContext ctx = this.attributeContext;
        if (ctx == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        if (ctx.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AttributeFilterContext filterContext = this.filterContextCreationStrategy.apply(profileRequestContext);
        if (filterContext == null) {
            this.log.error("{} Unable to locate or create AttributeFilterContext", (Object)this.getLogPrefix());
            if (this.maskFailures) {
                this.log.warn("Filter error masked, clearing resolved attributes");
                this.attributeContext.setIdPAttributes(null);
            } else {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToFilterAttributes");
            }
            return;
        }
        this.populateFilterContext(profileRequestContext, filterContext);
        try (ServiceableComponent component = this.attributeFilterService.getServiceableComponent();){
            AttributeFilter filter = (AttributeFilter)component.getComponent();
            filter.filterAttributes(filterContext);
            filterContext.removeFromParent();
            this.attributeContext.setIdPAttributes(filterContext.getFilteredIdPAttributes().values());
        }
        catch (AttributeFilterException e) {
            this.log.error("{} Error encountered while filtering attributes", (Object)this.getLogPrefix(), (Object)e);
            if (this.maskFailures) {
                this.log.warn("Filter error masked, clearing resolved attributes");
                this.attributeContext.setIdPAttributes((Collection)CollectionSupport.emptySet());
            } else {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToFilterAttributes");
            }
        }
        catch (ServiceException e) {
            this.log.error("{} Invalid Attribute Filter service configuration", (Object)this.getLogPrefix(), (Object)e);
            if (this.maskFailures) {
                this.log.warn("Filter error masked, clearing resolved attributes");
                this.attributeContext.setIdPAttributes(null);
            }
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToFilterAttributes");
        }
    }

    private void populateFilterContext(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AttributeFilterContext filterContext) {
        filterContext.setDirection(AttributeFilterContext.Direction.OUTBOUND).setMetadataResolver(this.metadataResolver).setPrincipal(this.principalNameLookupStrategy.apply(profileRequestContext)).setAttributeRecipientID(this.recipientLookupStrategy != null ? this.recipientLookupStrategy.apply(profileRequestContext) : null).setAttributeIssuerID(this.issuerLookupStrategy != null ? this.issuerLookupStrategy.apply(profileRequestContext) : null).setIssuerMetadataContextLookupStrategy(this.issuerMetadataFromFilterLookupStrategy).setRequesterMetadataContextLookupStrategy(this.metadataFromFilterLookupStrategy).setProxiedRequesterContextLookupStrategy(this.proxiesFromFilterLookupStrategy).setProxiedRequesterMetadataContextLookupStrategy(this.proxiedMetadataFromFilterLookupStrategy);
        if (filterContext.getPrefilteredIdPAttributes().isEmpty()) {
            assert (this.attributeContext != null);
            filterContext.setPrefilteredIdPAttributes(this.attributeContext.getIdPAttributes().values());
        }
    }
}

