/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.support;

import java.io.IOException;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class StorageAwareCookieManager
extends CookieManager {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(StorageAwareCookieManager.class);
    @Nullable
    private StorageService storageService;
    @Nullable
    private Function<ProfileRequestContext, String> usernameLookupStrategy;
    @NonnullAfterInit
    private String storageContext;

    public void setStorageService(@Nullable StorageService ss) {
        this.checkSetterPreconditions();
        this.storageService = ss;
    }

    @NonnullAfterInit
    public String getStorageContext() {
        return this.storageContext;
    }

    public void setUsernameLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.usernameLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageService != null) {
            if (this.getMaxAge() == -1) {
                throw new ComponentInitializationException("StorageService cannot be used for per-session cookie manager.");
            }
            if (this.usernameLookupStrategy == null) {
                throw new ComponentInitializationException("StorageService use requires a username lookup strategy.");
            }
        }
        StringBuilder contextBuilder = new StringBuilder(((Object)((Object)this)).getClass().getName());
        contextBuilder.append('!');
        if (this.getCookieDomain() != null) {
            contextBuilder.append(this.getCookieDomain());
        }
        contextBuilder.append('!');
        if (this.getCookiePath() != null) {
            contextBuilder.append(this.getCookiePath());
        }
        this.storageContext = contextBuilder.toString();
    }

    public void addCookie(@Nonnull String name, @Nonnull String value) {
        super.addCookie(name, value);
        Long exp = Instant.now().plusSeconds(this.getMaxAge()).toEpochMilli();
        StorageService ss = this.storageService;
        if (ss != null) {
            try {
                String cookieName = this.getPartitionedCookieName(name);
                if (ss.create(this.storageContext, cookieName, value, exp)) {
                    this.log.trace("Created new cookie record {}", (Object)cookieName);
                } else if (ss.update(this.storageContext, cookieName, value, exp)) {
                    this.log.trace("Updated cookie record {}", (Object)cookieName);
                }
            }
            catch (IOException e) {
                this.log.warn("Error creating/updating cookie record in storage service", (Throwable)e);
            }
        }
    }

    public void unsetCookie(@Nonnull String name) {
        super.unsetCookie(name);
        StorageService ss = this.storageService;
        if (ss != null) {
            try {
                String cookieName = this.getPartitionedCookieName(name);
                ss.delete(this.storageContext, cookieName);
                this.log.trace("Deleted cookie record {}", (Object)cookieName);
            }
            catch (IOException e) {
                this.log.warn("Error deleting cookie record from storage service", (Throwable)e);
            }
        }
    }

    @Nullable
    public String getCookieValue(@Nonnull String name, @Nullable String defValue) {
        StorageService ss = this.storageService;
        if (ss != null) {
            try {
                String val = super.getCookieValue(name, null);
                if (val != null) {
                    return val;
                }
                String cookieName = this.getPartitionedCookieName(name);
                StorageRecord record = ss.read(this.storageContext, cookieName);
                if (record != null) {
                    this.log.debug("Backfilling/setting missing cookie {} based on stored record", (Object)cookieName);
                    Long exp = record.getExpiration();
                    if (exp != null) {
                        super.addCookie(name, record.getValue(), (int)(exp - Instant.now().toEpochMilli()) / 1000);
                    } else {
                        super.addCookie(name, record.getValue(), -1);
                    }
                    return record.getValue();
                }
            }
            catch (IOException e) {
                this.log.warn("Error reading cookie record from storage service", (Throwable)e);
            }
        } else {
            return super.getCookieValue(name, defValue);
        }
        return defValue;
    }

    @Nonnull
    protected String getPartitionedCookieName(@Nonnull String cookieName) throws IOException {
        Object obj = this.getHttpServletRequest().getAttribute("opensamlProfileRequestContext");
        if (obj instanceof ProfileRequestContext) {
            String username;
            ProfileRequestContext prc = (ProfileRequestContext)obj;
            String string = username = this.usernameLookupStrategy != null ? this.usernameLookupStrategy.apply(prc) : null;
            if (username != null) {
                return cookieName + "!" + username;
            }
            throw new IOException("Username was unavailable");
        }
        throw new IOException("ProfileRequestContext was unavailable");
    }
}

