/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import java.util.List;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractDynamicMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.HttpClientFactoryBean;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractDynamicHTTPMetadataProviderParser
extends AbstractDynamicMetadataProviderParser {
    private static final String BASIC_AUTH_USER = "basicAuthUser";
    private static final String BASIC_AUTH_PASSWORD = "basicAuthPassword";
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicHTTPMetadataProviderParser.class);

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "httpClientRef")) {
            builder.addConstructorArgReference(element.getAttributeNS(null, "httpClientRef"));
            if (element.hasAttributeNS(null, "requestTimeout") || element.hasAttributeNS(null, "disregardSslCertificate") || element.hasAttributeNS(null, "proxyHost") || element.hasAttributeNS(null, "proxyPort") || element.hasAttributeNS(null, "proxyUser") || element.hasAttributeNS(null, "proxyPassword")) {
                this.log.warn("httpClientRef overrides settings for requestTimeout, disregardSslCertificate, proxyHost, proxyPort, proxyUser and proxyPassword");
            }
        } else {
            builder.addConstructorArgValue((Object)this.buildHttpClient(element));
        }
        if (element.hasAttributeNS(null, "credentialsProviderRef")) {
            builder.addPropertyReference("credentialsProviderRef", element.getAttributeNS(null, "credentialsProviderRef"));
            if (element.hasAttributeNS(null, BASIC_AUTH_USER) || element.hasAttributeNS(null, BASIC_AUTH_PASSWORD)) {
                this.log.warn("credentialsProviderRef overrides settings for basicAuthUser and basicAuthPassword");
            }
        } else if (element.hasAttributeNS(null, BASIC_AUTH_USER) || element.hasAttributeNS(null, BASIC_AUTH_PASSWORD)) {
            builder.addPropertyValue("basicCredentials", (Object)this.buildBasicCredentials(element));
        }
        if (element.hasAttributeNS(null, "supportedContentTypes")) {
            List supportedContentTypes = StringSupport.stringToList((String)element.getAttributeNS(null, "supportedContentTypes"), (String)" \n\r\t");
            builder.addPropertyValue("supportedContentTypes", (Object)supportedContentTypes);
        }
    }

    private BeanDefinition buildHttpClient(Element element) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientFactoryBean.class);
        builder.setLazyInit(true);
        if (element.hasAttributeNS(null, "requestTimeout")) {
            builder.addPropertyValue("connectionTimeout", (Object)element.getAttributeNS(null, "requestTimeout"));
        }
        if (element.hasAttributeNS(null, "disregardSslCertificate")) {
            builder.addPropertyValue("connectionDisregardSslCertificate", (Object)element.getAttributeNS(null, "disregardSslCertificate"));
        }
        if (element.hasAttributeNS(null, "proxyHost")) {
            builder.addPropertyValue("connectionProxyHost", (Object)element.getAttributeNS(null, "proxyHost"));
        }
        if (element.hasAttributeNS(null, "proxyPort")) {
            builder.addPropertyValue("connectionProxyPort", (Object)element.getAttributeNS(null, "proxyPort"));
        }
        if (element.hasAttributeNS(null, "proxyUser")) {
            builder.addPropertyValue("connectionProxyUsername", (Object)element.getAttributeNS(null, "proxyUser"));
        }
        if (element.hasAttributeNS(null, "proxyPassword")) {
            builder.addPropertyValue("connectionProxyPassword", (Object)element.getAttributeNS(null, "proxyPassword"));
        }
        return builder.getBeanDefinition();
    }

    private BeanDefinition buildBasicCredentials(Element element) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(UsernamePasswordCredentials.class);
        builder.setLazyInit(true);
        builder.addConstructorArgValue((Object)element.getAttributeNS(null, BASIC_AUTH_USER));
        builder.addConstructorArgValue((Object)element.getAttributeNS(null, BASIC_AUTH_PASSWORD));
        return builder.getBeanDefinition();
    }
}

