/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractMetadataProviderParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractDynamicMetadataProviderParser
extends AbstractMetadataProviderParser {
    private static final String DEFAULT_PARSER_POOL_REF = "shibboleth.ParserPool";
    private static final String DEFAULT_TIMER_REF = "shibboleth.TaskTimer";
    private static final String DEFAULT_DELAY_FACTOR = "0.75";

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        builder.addConstructorArgReference(this.getTaskTimerRef(element));
        if (element.hasAttributeNS(null, "refreshDelayFactor")) {
            builder.addPropertyValue("refreshDelayFactor", (Object)element.getAttributeNS(null, "refreshDelayFactor"));
        } else {
            builder.addPropertyValue("refreshDelayFactor", (Object)DEFAULT_DELAY_FACTOR);
        }
        if (element.hasAttributeNS(null, "minCacheDuration")) {
            builder.addPropertyValue("minCacheDuration", (Object)element.getAttributeNS(null, "minCacheDuration"));
        }
        if (element.hasAttributeNS(null, "maxCacheDuration")) {
            builder.addPropertyValue("maxCacheDuration", (Object)element.getAttributeNS(null, "maxCacheDuration"));
        }
        if (element.hasAttributeNS(null, "maxIdleEntityData")) {
            builder.addPropertyValue("maxIdleEntityData", (Object)element.getAttributeNS(null, "maxIdleEntityData"));
        }
        if (element.hasAttributeNS(null, "removeIdleEntityData")) {
            builder.addPropertyValue("removeIdleEntityData", (Object)element.getAttributeNS(null, "removeIdleEntityData"));
        }
        if (element.hasAttributeNS(null, "cleanupTaskInterval")) {
            builder.addPropertyValue("cleanupTaskInterval", (Object)element.getAttributeNS(null, "cleanupTaskInterval"));
        }
        builder.addPropertyReference("parserPool", this.getParserPoolRef(element));
    }

    protected String getTaskTimerRef(Element element) {
        String taskTimerRef = null;
        if (element.hasAttributeNS(null, "taskTimerRef")) {
            taskTimerRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "taskTimerRef"));
        }
        if (taskTimerRef == null) {
            taskTimerRef = DEFAULT_TIMER_REF;
        }
        return taskTimerRef;
    }

    protected String getParserPoolRef(Element element) {
        String parserPoolRef = null;
        if (element.hasAttributeNS(null, "parserPoolRef")) {
            parserPoolRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "parserPoolRef"));
        }
        if (parserPoolRef == null) {
            parserPoolRef = DEFAULT_PARSER_POOL_REF;
        }
        return parserPoolRef;
    }
}

