/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.spring.relyingparty.RelyingPartyGroupParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.ChainingMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.MetadataNamespaceHandler;
import net.shibboleth.idp.profile.spring.relyingparty.security.SecurityNamespaceHandler;
import net.shibboleth.idp.saml.metadata.impl.RelyingPartyMetadataProvider;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.impl.MetadataFilterChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractMetadataProviderParser
extends AbstractSingleBeanDefinitionParser {
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataProviderParser.class);

    private boolean isPresentNotChaining(@Nonnull Element element, @Nonnull String attribute) {
        if (!element.hasAttributeNS(null, attribute)) {
            return false;
        }
        if (ChainingMetadataProviderParser.ELEMENT_NAME.equals(DOMTypeSupport.getXSIType((Element)element))) {
            this.log.warn("{} is not valid for {}", (Object)attribute, (Object)ChainingMetadataProviderParser.ELEMENT_NAME.getLocalPart());
            return false;
        }
        return true;
    }

    private boolean isTopMost(@Nonnull Element element) {
        Node parent = element.getParentNode();
        if (parent.getNodeType() == 9) {
            return true;
        }
        if (parent.getNodeType() != 1) {
            return false;
        }
        return RelyingPartyGroupParser.ELEMENT_NAME.getLocalPart().equals(parent.getLocalName()) && RelyingPartyGroupParser.ELEMENT_NAME.getNamespaceURI().equals(parent.getNamespaceURI());
    }

    protected abstract Class<? extends MetadataResolver> getNativeBeanClass(Element var1);

    protected final Class<? extends MetadataResolver> getBeanClass(Element element) {
        if (this.isTopMost(element)) {
            return RelyingPartyMetadataProvider.class;
        }
        return this.getNativeBeanClass(element);
    }

    protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        if (this.isTopMost(element)) {
            builder.setLazyInit(true);
            BeanDefinitionBuilder childBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getNativeBeanClass(element));
            this.doNativeParse(element, parserContext, childBeanDefinitionBuilder);
            builder.addConstructorArgValue((Object)childBeanDefinitionBuilder.getBeanDefinition());
            if (element.hasAttributeNS(null, "sortKey")) {
                builder.addPropertyValue("sortKey", (Object)element.getAttributeNS(null, "sortKey"));
            }
        } else {
            if (element.hasAttributeNS(null, "sortKey")) {
                this.log.warn("{} sortKey is only valid on 'top level' MetadataProviders", (Object)parserContext.getReaderContext().getResource().getDescription());
            }
            this.doNativeParse(element, parserContext, builder);
        }
    }

    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List filters;
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        builder.setLazyInit(true);
        builder.addPropertyValue("id", (Object)element.getAttributeNS(null, "id"));
        if (this.isPresentNotChaining(element, "failFastInitialization")) {
            builder.addPropertyValue("failFastInitialization", (Object)element.getAttributeNS(null, "failFastInitialization"));
        }
        if (this.isPresentNotChaining(element, "requireValidMetadata")) {
            builder.addPropertyValue("requireValidMetadata", (Object)element.getAttributeNS(null, "requireValidMetadata"));
        }
        if (null != (filters = ElementSupport.getChildElements((Node)element, (QName)MetadataNamespaceHandler.METADATA_FILTER_ELEMENT_NAME))) {
            if (filters.size() == 1) {
                builder.addPropertyValue("metadataFilter", (Object)SpringSupport.parseCustomElements((Collection)filters, (ParserContext)parserContext));
            } else if (filters.size() > 1) {
                BeanDefinitionBuilder chainBuilder = BeanDefinitionBuilder.genericBeanDefinition(MetadataFilterChain.class);
                chainBuilder.addPropertyValue("filters", (Object)SpringSupport.parseCustomElements((Collection)filters, (ParserContext)parserContext));
                builder.addPropertyValue("metadataFilter", (Object)chainBuilder.getBeanDefinition());
            }
        }
        List trustEngines = ElementSupport.getChildElements((Node)element, (QName)SecurityNamespaceHandler.TRUST_ENGINE_ELEMENT_NAME);
        SpringSupport.parseCustomElements((Collection)trustEngines, (ParserContext)parserContext);
    }
}

