/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class HttpClientFactoryBean
extends AbstractFactoryBean<HttpClient> {
    private final HttpClientBuilder builder = new HttpClientBuilder();
    @Duration
    private long connectionTimeout;

    public HttpClientFactoryBean() {
        StringBuilder stringBuilder = new StringBuilder("ShibbolethIdp/");
        stringBuilder.append(Version.getVersion()).append(" OpenSAML/").append(org.opensaml.core.Version.getVersion());
        this.builder.setUserAgent(stringBuilder.toString());
    }

    public Class<HttpClient> getObjectType() {
        return HttpClient.class;
    }

    public void setConnectionTimeout(@Duration long timeout) {
        this.connectionTimeout = timeout;
        if (timeout > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout was too large");
        }
        this.builder.setConnectionTimeout((int)timeout);
    }

    public void setConnectionDisregardSslCertificate(boolean disregard) {
        this.builder.setConnectionDisregardSslCertificate(disregard);
    }

    public void setConnectionProxyHost(String host) {
        this.builder.setConnectionProxyHost(host);
    }

    public void setConnectionProxyPort(int port) {
        this.builder.setConnectionProxyPort(port);
    }

    public void setConnectionProxyUsername(String usename) {
        this.builder.setConnectionProxyUsername(usename);
    }

    public void setConnectionProxyPassword(String password) {
        this.builder.setConnectionProxyPassword(password);
    }

    public void setUserAgent(@Nullable String agent) {
        this.builder.setUserAgent(agent);
    }

    protected HttpClient createInstance() throws Exception {
        return this.builder.buildClient();
    }
}

