/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.filter;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.opensaml.saml.common.profile.logic.EntityAttributesPredicate;
import org.opensaml.saml.common.profile.logic.EntityGroupNamePredicate;
import org.opensaml.saml.common.profile.logic.EntityIdPredicate;
import org.opensaml.saml.metadata.resolver.filter.impl.PredicateFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PredicateFilterParser
extends AbstractSingleBeanDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "Predicate");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PredicateFilterParser.class);

    protected Class<?> getBeanClass(Element element) {
        return PredicateFilter.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String direction;
        if (element.hasAttributeNS(null, "removeEmptyEntitiesDescriptors")) {
            builder.addPropertyValue("removeEmptyEntitiesDescriptors", (Object)element.getAttributeNS(null, "removeEmptyEntitiesDescriptors"));
        }
        if ((direction = element.getAttributeNS(null, "direction")) == null) {
            throw new BeanCreationException("Predicate filter requires 'direction' attribute");
        }
        if ("exclude".equals(direction)) {
            builder.addConstructorArgValue((Object)PredicateFilter.Direction.EXCLUDE);
        } else if ("include".equals(direction)) {
            builder.addConstructorArgValue((Object)PredicateFilter.Direction.INCLUDE);
        } else {
            throw new BeanCreationException("Predicate filter direction must be 'include' or 'exclude'");
        }
        if (element.hasAttributeNS(null, "conditionRef")) {
            this.log.info("Found conditionRef attribute, ignoring embedded Entity/Group/Tag elements");
            builder.addConstructorArgReference(element.getAttributeNS(null, "conditionRef"));
        } else {
            builder.addConstructorArgValue((Object)this.parseCustomElements(element));
        }
    }

    @Nonnull
    public BeanDefinition parseCustomElements(@Nonnull Element element) {
        BeanDefinitionBuilder entityIdPredicateBuilder = this.parseEntityPredicate(element);
        BeanDefinitionBuilder groupPredicateBuilder = this.parseGroupPredicate(element);
        BeanDefinitionBuilder tagPredicateBuilder = this.parseTagPredicate(element);
        int count = 0;
        if (entityIdPredicateBuilder != null) {
            ++count;
        }
        if (groupPredicateBuilder != null) {
            ++count;
        }
        if (tagPredicateBuilder != null) {
            ++count;
        }
        if (count == 0) {
            throw new BeanCreationException("No Entity, Group, or Tag element found");
        }
        if (count == 1) {
            if (entityIdPredicateBuilder != null) {
                return entityIdPredicateBuilder.getBeanDefinition();
            }
            if (groupPredicateBuilder != null) {
                return groupPredicateBuilder.getBeanDefinition();
            }
            return tagPredicateBuilder.getBeanDefinition();
        }
        BeanDefinitionBuilder orBuilder = BeanDefinitionBuilder.rootBeanDefinition(Predicates.class, (String)"or");
        ManagedList managedList = new ManagedList(count);
        if (entityIdPredicateBuilder != null) {
            managedList.add((Object)entityIdPredicateBuilder.getBeanDefinition());
        }
        if (groupPredicateBuilder != null) {
            managedList.add((Object)groupPredicateBuilder.getBeanDefinition());
        }
        if (tagPredicateBuilder != null) {
            managedList.add((Object)tagPredicateBuilder.getBeanDefinition());
        }
        orBuilder.addConstructorArgValue((Object)managedList);
        return orBuilder.getBeanDefinition();
    }

    @Nullable
    public BeanDefinitionBuilder parseEntityPredicate(@Nonnull Element element) {
        List entityList = ElementSupport.getChildElementsByTagNameNS((Node)element, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Entity");
        if (!entityList.isEmpty()) {
            ManagedList managedEntityList = SpringSupport.getElementTextContentAsManagedList((Collection)entityList);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(EntityIdPredicate.class);
            builder.addConstructorArgValue((Object)managedEntityList);
            return builder;
        }
        return null;
    }

    @Nullable
    public BeanDefinitionBuilder parseGroupPredicate(@Nonnull Element element) {
        List groupList = ElementSupport.getChildElementsByTagNameNS((Node)element, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Group");
        if (!groupList.isEmpty()) {
            ManagedList managedGroupList = SpringSupport.getElementTextContentAsManagedList((Collection)groupList);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(EntityGroupNamePredicate.class);
            builder.addConstructorArgValue((Object)managedGroupList);
            return builder;
        }
        return null;
    }

    @Nullable
    public BeanDefinitionBuilder parseTagPredicate(@Nonnull Element element) {
        List tagList = ElementSupport.getChildElementsByTagNameNS((Node)element, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Tag");
        if (!tagList.isEmpty()) {
            ManagedList managedTagList = new ManagedList(tagList.size());
            for (Element tag : tagList) {
                BeanDefinitionBuilder tagBuilder = BeanDefinitionBuilder.genericBeanDefinition(EntityAttributesPredicate.Candidate.class);
                tagBuilder.addConstructorArgValue((Object)tag.getAttributeNS(null, "name"));
                tagBuilder.addConstructorArgValue((Object)tag.getAttributeNS(null, "nameFormat"));
                List valueList = ElementSupport.getChildElementsByTagNameNS((Node)tag, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Value");
                if (!valueList.isEmpty()) {
                    ManagedList managedValueList = SpringSupport.getElementTextContentAsManagedList((Collection)valueList);
                    tagBuilder.addPropertyValue("values", (Object)managedValueList);
                }
                managedTagList.add((Object)tagBuilder.getBeanDefinition());
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(EntityAttributesPredicate.class);
            builder.addConstructorArgValue((Object)managedTagList);
            builder.addConstructorArgValue((Object)element.getAttributeNS(null, "trim"));
            return builder;
        }
        return null;
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

