/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.saml;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.profile.spring.relyingparty.saml.BaseSAML2ProfileConfigurationParser;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2BrowserSSOProfileParser
extends BaseSAML2ProfileConfigurationParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:relying-party:saml", "SAML2SSOProfile");
    private Logger log = LoggerFactory.getLogger(SAML2BrowserSSOProfileParser.class);

    public SAML2BrowserSSOProfileParser() {
        this.setArtifactAware(true);
    }

    protected Class<? extends BrowserSSOProfileConfiguration> getBeanClass(Element element) {
        return BrowserSSOProfileConfiguration.class;
    }

    @Override
    protected String getProfileBeanNamePrefix() {
        return "shibboleth.SAML2.BrowserSSO.";
    }

    private void setPropertiesFromRelyingParty(@Nonnull Element element, @Nonnull BeanDefinitionBuilder builder) {
        Node parentNode = element.getParentNode();
        if (parentNode == null) {
            this.log.warn("no parent to ProfileConfiguration, no defaultAuthenticationMethod set");
            return;
        }
        if (!(parentNode instanceof Element)) {
            this.log.warn("parent of ProfileConfiguration was unrecognizable, no defaultAuthenticationMethod set");
            return;
        }
        Element parent = (Element)parentNode;
        if (parent.hasAttributeNS(null, "defaultAuthenticationMethod")) {
            String method = StringSupport.trimOrNull((String)parent.getAttributeNS(null, "defaultAuthenticationMethod"));
            if (null == method) {
                return;
            }
            BeanDefinitionBuilder methodBuilder = BeanDefinitionBuilder.genericBeanDefinition(AuthnContextClassRefPrincipal.class);
            methodBuilder.addConstructorArgValue((Object)method);
            ManagedList methodsList = new ManagedList(1);
            methodsList.add(methodBuilder.getBeanDefinition());
            builder.addPropertyValue("defaultAuthenticationMethods", (Object)methodsList);
        }
        if (parent.hasAttributeNS(null, "nameIDFormatPrecedence")) {
            builder.addPropertyValue("nameIDFormatPrecedence", (Object)SpringSupport.getAttributeValueAsManagedList((Attr)parent.getAttributeNodeNS(null, "nameIDFormatPrecedence")));
        }
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "localityAddress")) {
            this.log.error("Deprecated attribute 'localityAddress' is being ignored");
            throw new BeanDefinitionParsingException(new Problem("Deprecated attribute 'localityAddress' is being ignored", new Location(parserContext.getReaderContext().getResource())));
        }
        if (element.hasAttributeNS(null, "localityDNSName")) {
            this.log.error("Deprecated attribute 'localityDNSName' is being ignored");
            throw new BeanDefinitionParsingException(new Problem("Deprecated attribute 'localityDNSName' is being ignored", new Location(parserContext.getReaderContext().getResource())));
        }
        if (element.hasAttributeNS(null, "includeAttributeStatement")) {
            builder.addPropertyValue("includeAttributeStatement", (Object)element.getAttributeNS(null, "includeAttributeStatement"));
        }
        if (element.hasAttributeNS(null, "maximumSPSessionLifetime")) {
            builder.addPropertyValue("maximumSPSessionLifetime", (Object)element.getAttributeNS(null, "maximumSPSessionLifetime"));
        }
        if (element.hasAttributeNS(null, "skipEndpointValidationWhenSigned")) {
            builder.addPropertyValue("skipEndpointValidationWhenSigned", (Object)element.getAttributeNS(null, "skipEndpointValidationWhenSigned"));
        }
        if (element.hasAttributeNS(null, "allowDelegation")) {
            builder.addPropertyValue("allowingDelegation", (Object)element.getAttributeNS(null, "allowDelegation"));
        }
        this.setPropertiesFromRelyingParty(element, builder);
    }
}

