/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.credential;

import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.idp.profile.spring.relyingparty.metadata.ResourceBackedMetadataProviderParser;
import net.shibboleth.idp.profile.spring.relyingparty.security.credential.AbstractCredentialFactoryBean;
import org.cryptacular.util.KeyPairUtil;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.UsageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;

public abstract class AbstractBasicCredentialFactoryBean
extends AbstractCredentialFactoryBean<BasicCredential> {
    private final Logger log = LoggerFactory.getLogger(ResourceBackedMetadataProviderParser.class);
    @Nullable
    private char[] secretKeyPassword;

    protected BasicCredential createInstance() throws Exception {
        BasicCredential credential;
        PrivateKey privateKey = this.getPrivateKey();
        PublicKey publicKey = this.getPublicKey();
        SecretKey secretKey = this.getSecretKey();
        if (null == publicKey) {
            this.log.error("{}: No Public Key Specified", (Object)this.getConfigDescription());
            throw new BeanCreationException("No Public Key specified");
        }
        if (null == privateKey) {
            credential = new BasicCredential(publicKey);
        } else {
            if (!KeyPairUtil.isKeyPair((PublicKey)publicKey, (PrivateKey)privateKey)) {
                this.log.error("{}: Public and private keys do not match", (Object)this.getConfigDescription());
                throw new BeanCreationException("Public and private keys do not match");
            }
            credential = new BasicCredential(publicKey, privateKey);
        }
        if (null != secretKey) {
            credential.setSecretKey(secretKey);
        }
        if (null != this.getUsageType()) {
            credential.setUsageType(UsageType.valueOf((String)this.getUsageType()));
        }
        return credential;
    }

    public Class<?> getObjectType() {
        return BasicCredential.class;
    }

    @Nullable
    public char[] getSecretKeyPassword() {
        return this.secretKeyPassword;
    }

    public void setSecretKeyPassword(@Nullable char[] password) {
        this.secretKeyPassword = (char[])(null != password && this.secretKeyPassword.length > 0 ? password : null);
    }

    @Nullable
    protected abstract PublicKey getPublicKey();

    @Nullable
    protected abstract PrivateKey getPrivateKey();

    @Nullable
    protected abstract SecretKey getSecretKey();
}

