/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.credential;

import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.spring.relyingparty.security.credential.AbstractX509CredentialFactoryBean;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.LazyList;
import org.cryptacular.util.KeyPairUtil;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;

public class X509InlineCredentialFactoryBean
extends AbstractX509CredentialFactoryBean {
    private final Logger log = LoggerFactory.getLogger(X509InlineCredentialFactoryBean.class);
    private String entityCertificate;
    private List<String> certificates;
    private byte[] privateKey;
    private List<String> crls;

    public void setEntity(@Nonnull String entityCert) {
        this.entityCertificate = entityCert;
    }

    public void setCertificates(@Nullable @NotEmpty List<String> certs) {
        this.certificates = certs;
    }

    public void setPrivateKey(@Nullable byte[] key) {
        this.privateKey = key;
    }

    public void setCRLs(@Nullable @NotEmpty List<String> list) {
        this.crls = list;
    }

    @Override
    @Nullable
    protected X509Certificate getEntityCertificate() {
        if (null == this.entityCertificate) {
            return null;
        }
        try {
            return X509Support.decodeCertificate((String)this.entityCertificate);
        }
        catch (CertificateException e) {
            this.log.error("{}: Could not decode provided Entity Certificate", (Object)this.getConfigDescription(), (Object)e);
            throw new FatalBeanException("Could not decode provided Entity Certificate", (Throwable)e);
        }
    }

    @Override
    @Nonnull
    protected List<X509Certificate> getCertificates() {
        LazyList certs = new LazyList();
        for (String cert : this.certificates) {
            try {
                certs.add(X509Support.decodeCertificate((String)cert.trim()));
            }
            catch (CertificateException e) {
                this.log.error("{}: Could not decode provided Certificate", (Object)this.getConfigDescription(), (Object)e);
                throw new FatalBeanException("Could not decode provided Certificate", (Throwable)e);
            }
        }
        return certs;
    }

    @Override
    @Nullable
    protected PrivateKey getPrivateKey() {
        if (null == this.privateKey) {
            return null;
        }
        return KeyPairUtil.decodePrivateKey((byte[])this.privateKey, (char[])this.getPrivateKeyPassword());
    }

    @Override
    @Nullable
    protected List<X509CRL> getCRLs() {
        if (null == this.crls) {
            return null;
        }
        LazyList result = new LazyList();
        for (String crl : this.crls) {
            try {
                result.add(X509Support.decodeCRL((String)crl));
            }
            catch (CRLException | CertificateException e) {
                this.log.error("{}: Could not decode provided CRL", (Object)this.getConfigDescription(), (Object)e);
                throw new FatalBeanException("Could not decode provided CRL", (Throwable)e);
            }
        }
        return result;
    }
}

