/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.trustengine;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ChainingSignatureTrustEngine;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class ChainingSignatureTrustEngineFactory
extends AbstractFactoryBean<ChainingSignatureTrustEngine> {
    private final List<Object> engines;

    public ChainingSignatureTrustEngineFactory(@Nonnull List<Object> list) {
        this.engines = (List)Constraint.isNotNull(list, (String)"Engine list must be non null");
    }

    public Class<?> getObjectType() {
        return ChainingSignatureTrustEngine.class;
    }

    protected ChainingSignatureTrustEngine createInstance() throws Exception {
        ArrayList<SignatureTrustEngine> list = new ArrayList<SignatureTrustEngine>(this.engines.size());
        for (Object engine : this.engines) {
            if (!(engine instanceof SignatureTrustEngine)) continue;
            list.add((SignatureTrustEngine)engine);
        }
        return new ChainingSignatureTrustEngine(list);
    }
}

