/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.trustengine;

import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.spring.relyingparty.security.trustengine.AbstractBasicPKIXValidationInfoFactoryBean;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;

public class PKIXInlineValidationInfoFactoryBean
extends AbstractBasicPKIXValidationInfoFactoryBean {
    private Logger log = LoggerFactory.getLogger(PKIXInlineValidationInfoFactoryBean.class);
    private List<String> certificateFiles;
    private List<String> crlStrings;

    public void setCertificates(@Nullable List<String> certs) {
        this.certificateFiles = certs;
    }

    public void setCRLs(@Nullable List<String> crls) {
        this.crlStrings = crls;
    }

    @Override
    @Nullable
    protected List<X509Certificate> getCertificates() {
        if (null == this.certificateFiles) {
            return null;
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(this.certificateFiles.size());
        for (String cert : this.certificateFiles) {
            try {
                certificates.add(X509Support.decodeCertificate((String)cert.trim()));
            }
            catch (CertificateException e) {
                this.log.error("{}: Could not decode provided Certificate", (Object)this.getConfigDescription(), (Object)e);
                throw new FatalBeanException("Could not decode provided Certificate", (Throwable)e);
            }
        }
        return certificates;
    }

    @Override
    @Nullable
    protected List<X509CRL> getCRLs() {
        if (null == this.crlStrings) {
            return null;
        }
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(this.crlStrings.size());
        for (String crl : this.crlStrings) {
            try {
                crls.add(X509Support.decodeCRL((String)crl));
            }
            catch (CRLException | CertificateException e) {
                this.log.error("{}: Could not decode provided CRL", (Object)this.getConfigDescription(), (Object)e);
                throw new FatalBeanException("Could not decode provided CRL", (Throwable)e);
            }
        }
        return crls;
    }
}

