/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.security.trustengine;

import java.io.File;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.spring.relyingparty.security.trustengine.AbstractBasicPKIXValidationInfoFactoryBean;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.Resource;

public class PKIXResourceValidationInfoFactoryBean
extends AbstractBasicPKIXValidationInfoFactoryBean {
    private Logger log = LoggerFactory.getLogger(PKIXResourceValidationInfoFactoryBean.class);
    private List<Resource> certificateFiles;
    private List<Resource> crlFiles;

    public void setCertificates(@Nullable List<Resource> certs) {
        this.certificateFiles = certs;
    }

    public void setCRLs(@Nullable List<Resource> crls) {
        this.crlFiles = crls;
    }

    @Override
    @Nullable
    protected List<X509Certificate> getCertificates() {
        if (null == this.certificateFiles) {
            return null;
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(this.certificateFiles.size());
        for (Resource f : this.certificateFiles) {
            try {
                certificates.addAll(X509Support.decodeCertificates((File)f.getFile()));
            }
            catch (IOException | CertificateException e) {
                this.log.error("{}: Could not decode Certificate at {}", new Object[]{this.getConfigDescription(), f.getDescription(), e});
                throw new FatalBeanException("Could not decode provided CertificateFile: " + f.getDescription(), (Throwable)e);
            }
        }
        return certificates;
    }

    @Override
    @Nullable
    protected List<X509CRL> getCRLs() {
        if (null == this.crlFiles) {
            return null;
        }
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(this.crlFiles.size());
        for (Resource crlFile : this.crlFiles) {
            try {
                crls.addAll(X509Support.decodeCRLs((File)crlFile.getFile()));
            }
            catch (IOException | CRLException e) {
                this.log.error("{}: Could not decode CRL file at {}: {}", new Object[]{this.getConfigDescription(), crlFile.getDescription(), e});
                throw new FatalBeanException("Could not decode provided CRL file " + crlFile.getDescription(), (Throwable)e);
            }
        }
        return crls;
    }
}

