/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.spring.factory.AbstractX509CredentialFactoryBean;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.LazyList;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.Resource;

public class BasicX509CredentialFactoryBean
extends AbstractX509CredentialFactoryBean {
    private final Logger log = LoggerFactory.getLogger(BasicX509CredentialFactoryBean.class);
    private Resource entityResource;
    private List<Resource> certificateResources;
    private Resource privateKeyResource;
    private List<Resource> crlResources;

    public void setEntity(@Nonnull Resource what) {
        this.entityResource = what;
    }

    public void setCertificates(@Nullable @NotEmpty List<Resource> what) {
        this.certificateResources = what;
    }

    public void setPrivateKey(@Nullable Resource what) {
        this.privateKeyResource = what;
    }

    public void setCRLs(@Nullable @NotEmpty List<Resource> what) {
        this.crlResources = what;
    }

    public void setPrivateKeyResource(@Nonnull Resource res) {
        this.setPrivateKey(res);
    }

    public void setPrivateKeyPassword(@Nullable String password) {
        this.setPrivateKeyPassword(password.toCharArray());
    }

    public void setCertificateResource(@Nonnull Resource res) {
        this.setCertificates(Collections.singletonList(res));
    }

    public void setEntityId(@Nullable String id) {
        this.setEntityID(id);
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    @Nullable
    protected X509Certificate getEntityCertificate() {
        if (null == this.entityResource) {
            return null;
        }
        try {
            Collection certs = X509Support.decodeCertificates((InputStream)this.entityResource.getInputStream());
            if (certs.size() > 1) {
                this.log.error("{}: Configuration element indicated an entityCertificate, but multiple certificates were decoded", (Object)this.getConfigDescription());
                throw new FatalBeanException("Configuration element indicated an entityCertificate, but multiple certificates were decoded");
            }
            return (X509Certificate)certs.iterator().next();
        }
        catch (IOException | CertificateException e) {
            this.log.error("{}: Could not decode provided Entity Certificate at {}: {}", new Object[]{this.getConfigDescription(), this.entityResource.getDescription(), e});
            throw new FatalBeanException("Could not decode provided Entity Certificate file " + this.entityResource.getDescription(), (Throwable)e);
        }
    }

    @Override
    @Nonnull
    protected List<X509Certificate> getCertificates() {
        LazyList certificates = new LazyList();
        for (Resource r : this.certificateResources) {
            try {
                InputStream is = r.getInputStream();
                Throwable throwable = null;
                try {
                    certificates.addAll(X509Support.decodeCertificates((InputStream)is));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | CertificateException e) {
                this.log.error("{}: could not decode CertificateFile at {}: {}", new Object[]{this.getConfigDescription(), r.getDescription(), e});
                throw new FatalBeanException("Could not decode provided CertificateFile: " + r.getDescription(), (Throwable)e);
            }
        }
        return certificates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected PrivateKey getPrivateKey() {
        if (null == this.privateKeyResource) {
            return null;
        }
        try (InputStream is = this.privateKeyResource.getInputStream();){
            PrivateKey privateKey = KeySupport.decodePrivateKey((InputStream)is, (char[])this.getPrivateKeyPassword());
            return privateKey;
        }
        catch (IOException | KeyException e) {
            this.log.error("{}: Could not decode KeyFile at {}: {}", new Object[]{this.getConfigDescription(), this.privateKeyResource.getDescription(), e});
            throw new FatalBeanException("Could not decode provided KeyFile " + this.privateKeyResource.getDescription(), (Throwable)e);
        }
    }

    @Override
    @Nullable
    protected List<X509CRL> getCRLs() {
        if (null == this.crlResources) {
            return null;
        }
        LazyList crls = new LazyList();
        for (Resource crl : this.crlResources) {
            try {
                InputStream is = crl.getInputStream();
                Throwable throwable = null;
                try {
                    crls.addAll(X509Support.decodeCRLs((InputStream)is));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException | CRLException e) {
                this.log.error("{}: Could not decode CRL file: {}", new Object[]{this.getConfigDescription(), crl.getDescription(), e});
                throw new FatalBeanException("Could not decode provided CRL file " + crl.getDescription(), (Throwable)e);
            }
        }
        return crls;
    }
}

