/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.impl;

import java.util.Collection;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractRelyingPartyParser
extends AbstractSingleBeanDefinitionParser {
    public static final QName PROFILE_CONFIGURATION = new QName("urn:mace:shibboleth:2.0:relying-party", "ProfileConfiguration");
    private Logger log = LoggerFactory.getLogger(AbstractRelyingPartyParser.class);

    protected Class<RelyingPartyConfiguration> getBeanClass(Element element) {
        return RelyingPartyConfiguration.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setLazyInit(true);
        super.doParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "defaultAuthenticationMethod")) {
            this.log.warn("Specific authentication methods may not work for all profiles.  defaultAuthenticationMethod='{}'", (Object)element.getAttributeNS(null, "defaultAuthenticationMethod"));
        }
        String provider = StringSupport.trimOrNull((String)element.getAttributeNS(null, "provider"));
        builder.addPropertyValue("responderId", (Object)provider);
        String detailedErrors = StringSupport.trimOrNull((String)element.getAttributeNS(null, "detailedErrors"));
        if (null != detailedErrors) {
            builder.addPropertyValue("detailedErrors", (Object)detailedErrors);
        }
        ManagedList profileConfigurations = SpringSupport.parseCustomElements((Collection)ElementSupport.getChildElements((Node)element, (QName)PROFILE_CONFIGURATION), (ParserContext)parserContext);
        builder.addPropertyValue("profileConfigurations", (Object)profileConfigurations);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }
}

