/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import net.shibboleth.idp.profile.spring.relyingparty.metadata.AbstractMetadataProviderParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractReloadingMetadataProviderParser
extends AbstractMetadataProviderParser {
    private static final String DEFAULT_PARSER_POOL_REF = "shibboleth.ParserPool";

    @Override
    protected void doNativeParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        String timerRef = this.getTaskTimerRef(element);
        if (timerRef != null) {
            builder.addConstructorArgReference(timerRef);
        }
        if (element.hasAttributeNS(null, "indexesRef")) {
            builder.addPropertyReference("indexes", StringSupport.trimOrNull((String)element.getAttributeNS(null, "indexesRef")));
        }
        if (element.hasAttributeNS(null, "resolveViaPredicatesOnly")) {
            builder.addPropertyValue("resolveViaPredicatesOnly", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "resolveViaPredicatesOnly")));
        }
        if (element.hasAttributeNS(null, "refreshDelayFactor")) {
            builder.addPropertyValue("refreshDelayFactor", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "refreshDelayFactor")));
        }
        if (element.hasAttributeNS(null, "maxRefreshDelay")) {
            builder.addPropertyValue("maxRefreshDelay", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxRefreshDelay")));
        }
        if (element.hasAttributeNS(null, "minRefreshDelay")) {
            builder.addPropertyValue("minRefreshDelay", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "minRefreshDelay")));
        }
        builder.addPropertyReference("parserPool", this.getParserPoolRef(element));
    }

    protected String getTaskTimerRef(Element element) {
        if (element.hasAttributeNS(null, "taskTimerRef")) {
            return StringSupport.trimOrNull((String)element.getAttributeNS(null, "taskTimerRef"));
        }
        return null;
    }

    protected String getParserPoolRef(Element element) {
        String parserPoolRef = null;
        if (element.hasAttributeNS(null, "parserPoolRef")) {
            parserPoolRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "parserPoolRef"));
        }
        if (parserPoolRef == null) {
            parserPoolRef = DEFAULT_PARSER_POOL_REF;
        }
        return parserPoolRef;
    }
}

