/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata.impl;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.metadata.RelyingPartyMetadataProvider;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public class MetadataResolverServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ApplicationContext, ServiceableComponent<MetadataResolver>> {
    @Nullable
    public ServiceableComponent<MetadataResolver> apply(@Nullable ApplicationContext appContext) {
        Collection resolvers = appContext.getBeansOfType(RelyingPartyMetadataProvider.class).values();
        if (resolvers.isEmpty()) {
            throw new ServiceException("Reload did not produce any bean of type" + RelyingPartyMetadataProvider.class.getName());
        }
        if (1 == resolvers.size()) {
            return (ServiceableComponent)resolvers.iterator().next();
        }
        for (RelyingPartyMetadataProvider resolver : resolvers) {
            try {
                resolver.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new BeanCreationException("could not preinitialize , metadata provider " + resolver.getId(), (Throwable)e);
            }
        }
        ArrayList resolverList = new ArrayList(resolvers.size());
        resolverList.addAll(resolvers);
        Collections.sort(resolverList);
        ChainingMetadataResolver chain = new ChainingMetadataResolver();
        try {
            chain.setResolvers(resolverList);
            chain.setId("MultiFileResolverFor:" + resolvers.size() + ":Resources");
            chain.initialize();
            RelyingPartyMetadataProvider result = new RelyingPartyMetadataProvider();
            result.setEmbeddedResolver((MetadataResolver)chain);
            result.initialize();
            return result;
        }
        catch (ComponentInitializationException | ResolverException e) {
            throw new ServiceException("Chaining constructor create failed", (Exception)e);
        }
    }
}

