/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.VfsResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.webflow.config.FlowDefinitionResource;
import org.springframework.webflow.core.collection.AttributeMap;

public class FlowDefinitionResourceFactory {
    @Nonnull
    @NotEmpty
    private static final String CLASSPATH_SCHEME = "classpath:";
    @Nonnull
    @NotEmpty
    private static final String CLASSPATH_STAR_SCHEME = "classpath*:";
    @Nonnull
    @NotEmpty
    private static final String FILESYSTEM_SCHEME = "file:";
    @Nonnull
    @NotEmpty
    private static final String SLASH = "/";
    @Nonnull
    private final ResourceLoader resourceLoader;

    public FlowDefinitionResourceFactory(@Nonnull ResourceLoader loader) {
        this.resourceLoader = (ResourceLoader)Constraint.isNotNull((Object)loader, (String)"The resource loader cannot be null");
    }

    public FlowDefinitionResource createResource(@Nullable String basePath, @Nonnull @NotEmpty String path, @Nonnull AttributeMap<Object> attributes, @Nonnull @NotEmpty String flowId) {
        Resource resource;
        Constraint.isNotEmpty((String)path, (String)"Flow path cannot be null or empty");
        Constraint.isNotEmpty((String)flowId, (String)"Flow ID cannot be null or empty");
        if (basePath == null || this.isAbsolute(path)) {
            resource = this.resourceLoader.getResource(path);
        } else {
            resource = this.resourceLoader.getResource(path);
            if (!resource.exists()) {
                try {
                    Object localBasePath = basePath;
                    if (!((String)localBasePath).endsWith(SLASH)) {
                        localBasePath = basePath + SLASH;
                    }
                    resource = this.resourceLoader.getResource((String)localBasePath).createRelative(path);
                }
                catch (IOException e) {
                    throw new IllegalStateException("The base path cannot be resolved from '" + basePath + "'", e);
                }
            }
        }
        return new FlowDefinitionResource(flowId, resource, attributes);
    }

    @Nonnull
    public Collection<FlowDefinitionResource> createResources(@Nonnull @NotEmpty String basePath, @Nonnull @NotEmpty String pattern, @Nonnull AttributeMap<Object> attributes) throws IOException {
        Constraint.isNotEmpty((String)basePath, (String)"Base location cannot be null or empty");
        Constraint.isNotEmpty((String)pattern, (String)"Flow pattern cannot be null or empty");
        if (!(this.resourceLoader instanceof ResourcePatternResolver)) {
            throw new IllegalStateException("Cannot create flow definition resources from patterns without a ResourcePatternResolver");
        }
        ResourcePatternResolver resolver = (ResourcePatternResolver)this.resourceLoader;
        Resource[] resources = this.isAbsolute(pattern) ? resolver.getResources(pattern) : (basePath.endsWith(SLASH) || pattern.startsWith(SLASH) ? resolver.getResources(basePath + pattern) : resolver.getResources(basePath + SLASH + pattern));
        if (resources.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FlowDefinitionResource> flowResources = new ArrayList<FlowDefinitionResource>(resources.length);
        for (Resource resource : resources) {
            flowResources.add(new FlowDefinitionResource(this.getFlowId(basePath, resource), resource, attributes));
        }
        return flowResources;
    }

    protected String getFlowId(@Nonnull @NotEmpty String basePath, @Nonnull Resource flowResource) throws IOException {
        String filePath;
        String localBasePath = this.removeScheme(basePath);
        if (flowResource instanceof ContextResource) {
            filePath = ((ContextResource)flowResource).getPathWithinContext();
        } else if (flowResource instanceof ClassPathResource) {
            filePath = ((ClassPathResource)flowResource).getPath();
        } else if (flowResource instanceof FileSystemResource) {
            filePath = this.truncateFilePath(((FileSystemResource)flowResource).getPath(), localBasePath);
        } else if (flowResource instanceof UrlResource || flowResource instanceof VfsResource) {
            filePath = this.truncateFilePath(flowResource.getURL().getPath(), localBasePath);
        } else {
            return StringUtils.stripFilenameExtension((String)flowResource.getFilename());
        }
        int beginIndex = 0;
        int endIndex = filePath.length();
        if (filePath.startsWith(localBasePath)) {
            beginIndex = localBasePath.length();
        } else if (filePath.startsWith(SLASH + localBasePath)) {
            beginIndex = localBasePath.length() + 1;
        }
        if (filePath.startsWith(SLASH, beginIndex)) {
            ++beginIndex;
        }
        if (filePath.lastIndexOf(SLASH) < beginIndex) {
            return StringUtils.stripFilenameExtension((String)flowResource.getFilename());
        }
        endIndex = filePath.lastIndexOf(SLASH);
        return filePath.substring(beginIndex, endIndex);
    }

    @Nonnull
    @NotEmpty
    private String truncateFilePath(@Nonnull @NotEmpty String filePath, @Nonnull @NotEmpty String basePath) {
        int basePathIndex = filePath.lastIndexOf(basePath);
        if (basePathIndex != -1) {
            return filePath.substring(basePathIndex);
        }
        return filePath;
    }

    private boolean isAbsolute(@Nonnull @NotEmpty String path) {
        if (path.startsWith(CLASSPATH_SCHEME)) {
            return true;
        }
        if (path.startsWith(CLASSPATH_STAR_SCHEME)) {
            return true;
        }
        return path.startsWith(FILESYSTEM_SCHEME);
    }

    private String removeScheme(@Nonnull @NotEmpty String path) {
        if (path.startsWith(CLASSPATH_SCHEME)) {
            return path.substring(CLASSPATH_SCHEME.length());
        }
        if (path.startsWith(FILESYSTEM_SCHEME)) {
            return path.substring(FILESYSTEM_SCHEME.length());
        }
        if (path.startsWith(CLASSPATH_STAR_SCHEME)) {
            return path.substring(CLASSPATH_STAR_SCHEME.length());
        }
        return path;
    }
}

