/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import java.io.IOException;
import net.shibboleth.ext.spring.resource.ConditionalResourceResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

class FlowRelativeResourceLoader
extends DefaultResourceLoader {
    private Resource flowResource;

    public FlowRelativeResourceLoader(Resource resource) {
        this.flowResource = resource;
        this.getProtocolResolvers().add(new ConditionalResourceResolver());
    }

    public ClassLoader getClassLoader() {
        return this.flowResource.getClass().getClassLoader();
    }

    public Resource getResource(String location) {
        Resource r = super.getResource(location);
        if (r.exists()) {
            return r;
        }
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()), this.getClassLoader());
        }
        return this.createFlowRelativeResource(location);
    }

    private Resource createFlowRelativeResource(String location) {
        try {
            return this.flowResource.createRelative(location);
        }
        catch (IOException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Unable to access a flow relative resource at location '" + location + "'");
            iae.initCause(e);
            throw iae;
        }
    }

    protected Resource getResourceByPath(String path) {
        FileSystemResource r = new FileSystemResource(path);
        if (r.exists()) {
            return r;
        }
        return super.getResourceByPath(path);
    }
}

