/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.relyingparty.metadata;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ScriptTypeBeanParser {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(ScriptTypeBeanParser.class);

    private ScriptTypeBeanParser() {
    }

    @Nonnull
    public static BeanDefinitionBuilder parseScriptType(@Nonnull Class<?> type, @Nonnull Element element) {
        String customRef;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(type);
        if (element.hasAttributeNS(null, "language")) {
            String scriptLanguage = StringSupport.trimOrNull((String)element.getAttributeNS(null, "language"));
            builder.addConstructorArgValue((Object)scriptLanguage);
        }
        if (null != (customRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "customObjectRef")))) {
            builder.addPropertyReference("customObject", customRef);
        }
        Element scriptChild = ElementSupport.getFirstChildElement((Node)element);
        builder.addConstructorArgValue((Object)ElementSupport.getElementContentAsString((Element)scriptChild));
        if (ElementSupport.isElementNamed((Element)scriptChild, (String)element.getNamespaceURI(), (String)"Script")) {
            builder.setFactoryMethod("inlineScript");
        } else if (ElementSupport.isElementNamed((Element)scriptChild, (String)element.getNamespaceURI(), (String)"ScriptFile")) {
            builder.setFactoryMethod("resourceScript");
        }
        return builder;
    }
}

